set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '2400334',
      3,
      4,
      NULL,
      0,
      '210334',
      0,
      NULL,
      NULL,
      NULL,
      0.818705,
      NULL,
      1.920361,
      0,
      NULL,
      1.071187,
      0.006810,
      3,
      1.827279,
      2.300559,
      0,
      0,
      NULL,
      0,
      0.718172,
      0,
      1.462259,
      2.090951,
      6.939564,
      0,
      2,
      1,
      0.306599,
      0,
      0,
      1,
      1.178632,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      5.253231,
      3,
      NULL,
      1,
      NULL,
      NULL,
      2.298584,
      NULL,
      2.015052,
      1.721367,
      NULL,
      3,
      1,
      0.839731,
      0,
      NULL,
      2.986645,
      1,
      NULL,
      0,
      6.083631,
      NULL,
      NULL,
      1.686071,
      1,
      NULL,
      NULL,
      0.351761,
      NULL,
      NULL,
      NULL,
      0.606172,
      3.149645,
      NULL,
      0,
      NULL,
      2,
      0.677219,
      1,
      0.244332,
      3,
      NULL,
      1,
      1,
      1,
      0.432895,
      NULL,
      0,
      0.520062,
      NULL,
      1,
      3,
      1.338830,
      1,
      0.200295,
      2.219937,
      1.202791,
      1,
      1,
      0.220847,
      NULL,
      5.532539,
      0,
      0.872032,
      2,
      1.385498,
      4.918498,
      6.577925,
      0.830947,
      3.458106,
      1.730759,
      NULL,
      NULL,
      0.239301,
      1.626456,
      3,
      1.207443,
      NULL,
      2.644098,
      1,
      0.011906,
      NULL,
      1.559462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.966737,
      2,
      1,
      0,
      1.194682,
      1,
      1.238675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.415981,
      NULL,
      0.922152,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.276639,
      0.664094,
      NULL,
      0.627414,
      0,
      2.971395,
      NULL,
      0.103277,
      1,
      1,
      0,
      0,
      NULL,
      1.159184,
      0.362301,
      0.429045,
      0.389486,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185514,
      '13204',
      '43300',
      '',
      1.748767,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


