set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '4044421',
      34.924975,
      3,
      0.112641,
      1,
      '002030',
      2.332493,
      '10-10-1995',
      NULL,
      NULL,
      0.138792,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3.393793,
      1,
      2.783847,
      2.660485,
      1.212822,
      NULL,
      1,
      1,
      1,
      3,
      1.522737,
      1.355136,
      0.501466,
      0,
      0,
      NULL,
      1,
      2.163084,
      1,
      2.186673,
      NULL,
      1.804921,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.056707,
      5.207830,
      1,
      2.914867,
      NULL,
      0.413471,
      1,
      3.811394,
      NULL,
      3,
      0,
      1,
      0,
      3.187991,
      1.219636,
      0.586119,
      0,
      2,
      NULL,
      1.268784,
      0,
      1.134866,
      4.932732,
      1,
      0,
      NULL,
      0.795212,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1.982605,
      1,
      1,
      1,
      0,
      1.719028,
      0,
      NULL,
      0.856733,
      4,
      0,
      1,
      NULL,
      0,
      5.632274,
      0.443948,
      3.318330,
      1,
      2.266889,
      NULL,
      1.214493,
      0,
      NULL,
      1,
      1.203278,
      7.334797,
      NULL,
      0.255004,
      1.201512,
      2.251179,
      0.258704,
      1.347884,
      1,
      3,
      1,
      3.818414,
      0.787345,
      0,
      NULL,
      4.606621,
      0.611369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850214,
      3.696303,
      0,
      0,
      NULL,
      1,
      1,
      1.402587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773995,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.029793,
      0.554731,
      NULL,
      1.156985,
      1.390473,
      1.724382,
      3,
      0,
      0.746275,
      1,
      1.382546,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.168540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '02004',
      '32214',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


