set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '1444342',
      28.008182,
      NULL,
      0.017714,
      NULL,
      '240432',
      1.178903,
      ' 2- 3-1995',
      14.490625,
      NULL,
      NULL,
      NULL,
      2.270626,
      0.903316,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      2,
      1,
      0.358409,
      NULL,
      0,
      0,
      NULL,
      1,
      4.706241,
      1,
      0.446686,
      0.118463,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1.279175,
      NULL,
      NULL,
      5,
      3,
      NULL,
      2.756947,
      1,
      0.109697,
      3.349301,
      NULL,
      2.992015,
      2.112793,
      NULL,
      1,
      NULL,
      0.343478,
      1.522875,
      1,
      2.986993,
      NULL,
      NULL,
      NULL,
      1.218021,
      0.840436,
      0.379983,
      0,
      1,
      0,
      0.941415,
      NULL,
      NULL,
      1.987165,
      NULL,
      NULL,
      0.281081,
      0.527207,
      3,
      NULL,
      0,
      NULL,
      3,
      1,
      1.986827,
      1.558380,
      NULL,
      0.168897,
      1,
      NULL,
      1,
      1,
      1.731047,
      0.827568,
      1.823493,
      NULL,
      1.796505,
      1,
      0.260402,
      1.149536,
      0,
      1.091177,
      5,
      1,
      1,
      NULL,
      NULL,
      5,
      1.428232,
      1,
      3,
      0,
      3,
      2.256201,
      NULL,
      0,
      2,
      0,
      0.150136,
      1,
      NULL,
      3,
      0,
      3.245979,
      3,
      0,
      0.342718,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.653465,
      1,
      1,
      0.522939,
      0.002597,
      1.703841,
      0.710772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.494359,
      NULL,
      1,
      1.927749,
      NULL,
      0.062689,
      NULL,
      NULL,
      NULL,
      1,
      0.519983,
      0.083355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.758200,
      3,
      3,
      0.245893,
      0,
      NULL,
      0,
      3.137405,
      NULL,
      NULL,
      3.575484,
      0,
      1,
      1,
      1.586147,
      1,
      NULL,
      1.798584,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718607,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588478,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0.379527,
      0.295292,
      1.139803,
      1,
      NULL,
      '03140',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.471729,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


