set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '1021142',
      64,
      1,
      NULL,
      NULL,
      '024001',
      1,
      ' 4- 7-2000',
      29,
      NULL,
      1,
      NULL,
      0.950018,
      1.767816,
      NULL,
      1.748257,
      1,
      0,
      0.554604,
      0,
      0,
      1.765878,
      NULL,
      1,
      0.132940,
      1.102374,
      3,
      1,
      1.264052,
      1.674892,
      NULL,
      0,
      1.380242,
      NULL,
      1.804411,
      0,
      0,
      2.705219,
      3,
      1.383704,
      NULL,
      NULL,
      1.204705,
      NULL,
      NULL,
      4.305176,
      NULL,
      1,
      0,
      1.380462,
      NULL,
      0.501536,
      2.186325,
      0,
      2,
      NULL,
      1.553947,
      0,
      0.880535,
      1,
      NULL,
      NULL,
      1.155019,
      0,
      1.522091,
      NULL,
      0,
      7.275922,
      NULL,
      1,
      1,
      1.861045,
      NULL,
      NULL,
      1.840996,
      NULL,
      NULL,
      0,
      NULL,
      1.467704,
      0,
      NULL,
      0.728799,
      NULL,
      1.762338,
      NULL,
      0,
      0,
      1,
      1.609651,
      1.179044,
      1,
      1,
      1.140813,
      NULL,
      1,
      NULL,
      0.548806,
      5,
      NULL,
      NULL,
      1.050916,
      0,
      2,
      0,
      2.957629,
      1,
      NULL,
      2,
      0.497799,
      1.676290,
      1.679961,
      1.441695,
      0.547689,
      NULL,
      NULL,
      5,
      1,
      5.509712,
      NULL,
      1.565662,
      1.529611,
      5,
      0,
      2.143564,
      1,
      NULL,
      NULL,
      2.824126,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403259,
      NULL,
      NULL,
      1,
      0,
      0.364875,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.101557,
      1.928074,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.414933,
      2,
      1,
      1,
      NULL,
      NULL,
      2,
      0.115578,
      0,
      1.851924,
      1,
      NULL,
      0.899147,
      NULL,
      1.799022,
      0.247757,
      0.232251,
      0.680635,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '14020',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1.423656,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


