set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      NULL,
      31.407627,
      7,
      '4204113',
      5,
      4,
      NULL,
      1,
      '120214',
      0,
      ' 0- 4-1988',
      56.074779,
      49.083932,
      0.320057,
      NULL,
      2.724471,
      1.671357,
      0,
      1.958600,
      0.043703,
      0,
      1.174297,
      2.674228,
      NULL,
      1.444155,
      NULL,
      NULL,
      1.069031,
      0.334503,
      0,
      1,
      3.007471,
      0.967548,
      2,
      NULL,
      NULL,
      1.354406,
      5,
      0,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.510592,
      6,
      9.328682,
      3,
      0,
      0.787570,
      NULL,
      2.886893,
      0.462844,
      1,
      2,
      0,
      1.949106,
      2.782400,
      NULL,
      1.797858,
      0,
      0,
      0.542847,
      0.530115,
      1,
      0,
      NULL,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.849882,
      1,
      0,
      3.222966,
      3.625604,
      1.925445,
      0,
      1.461962,
      1.175709,
      1.232577,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.639461,
      1.072395,
      1.777703,
      0.531361,
      1.249080,
      0,
      0,
      0.076859,
      0.888876,
      1,
      0,
      NULL,
      3,
      1,
      1,
      NULL,
      0.675107,
      NULL,
      0.795451,
      NULL,
      1,
      NULL,
      1,
      1,
      2.096131,
      NULL,
      0.930181,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140081,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.697005,
      1.660630,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.984310,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.621604,
      NULL,
      1.949081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.201001,
      NULL,
      1,
      1.654561,
      1.667523,
      NULL,
      NULL,
      NULL,
      3.854640,
      NULL,
      1,
      0.052682,
      NULL,
      NULL,
      1,
      0,
      0.347855,
      1.299679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '11323',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4.829561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


