set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '332',
      NULL,
      17.597982,
      10.133438,
      NULL,
      5.148589,
      NULL,
      NULL,
      2,
      '004030',
      2,
      ' 7- 8-1991',
      NULL,
      6.886471,
      0,
      NULL,
      3,
      0.428677,
      3,
      1,
      3.307257,
      NULL,
      0,
      0,
      1.554921,
      1,
      5,
      0.968305,
      NULL,
      NULL,
      NULL,
      1,
      1.085759,
      1,
      1,
      NULL,
      0,
      0,
      5.376408,
      0,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      0.645987,
      NULL,
      NULL,
      5.174802,
      3.243145,
      0,
      0.034211,
      NULL,
      0,
      NULL,
      3.319798,
      0.620152,
      NULL,
      0,
      0,
      1.063674,
      0,
      NULL,
      0.400955,
      2.038014,
      0,
      1.599404,
      NULL,
      0,
      1,
      0.024081,
      1,
      2,
      3.702977,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      1.905316,
      0,
      1,
      NULL,
      1,
      0.450728,
      1.748004,
      0.189856,
      0.537495,
      1,
      1,
      NULL,
      1,
      0,
      0.364126,
      NULL,
      1.260902,
      3,
      0.002730,
      NULL,
      NULL,
      1,
      3,
      1,
      1.250835,
      0.374676,
      0.470605,
      1.933238,
      1,
      1,
      1.307100,
      NULL,
      1.342530,
      5,
      1.986223,
      2.867865,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2,
      3.434952,
      0,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.588826,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      1.520640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974840,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.355440,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.975050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423553,
      1.371068,
      0.059994,
      2,
      3.398401,
      NULL,
      0.145929,
      0,
      NULL,
      NULL,
      1.440943,
      0.814147,
      1,
      1.666579,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.123554,
      '24020',
      '',
      '',
      0.764366,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


