set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '420',
      NULL,
      16.654476,
      20,
      '3220223',
      NULL,
      1,
      2.839985,
      1,
      '424124',
      NULL,
      ' 1-18-1991',
      21,
      19,
      0.666928,
      NULL,
      1.504375,
      0.258883,
      1,
      NULL,
      0.148779,
      0,
      1.941559,
      3,
      0,
      1.523453,
      3,
      NULL,
      1.970581,
      NULL,
      0,
      1,
      4.811377,
      0,
      0,
      1.229248,
      NULL,
      NULL,
      0,
      0,
      3,
      0.655345,
      1.077688,
      0,
      NULL,
      NULL,
      0.926993,
      NULL,
      NULL,
      3,
      3.666051,
      0.359977,
      0,
      1.109412,
      1,
      3.853780,
      3.586723,
      1,
      0.387614,
      1,
      1,
      NULL,
      3,
      0,
      0.446442,
      2.050087,
      0,
      3,
      1.549861,
      0,
      0,
      2.879229,
      1,
      0,
      0.792695,
      0.458084,
      NULL,
      NULL,
      1.672742,
      NULL,
      NULL,
      0.610450,
      1.109952,
      NULL,
      NULL,
      0.105519,
      1,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.837247,
      1,
      NULL,
      NULL,
      1.252849,
      0,
      NULL,
      1,
      3.698301,
      1.003241,
      0.367879,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1.881692,
      1,
      1.380594,
      1.011453,
      1,
      NULL,
      NULL,
      2,
      1,
      1.872050,
      1.193965,
      3,
      3,
      0,
      1,
      0,
      1,
      0.705777,
      0,
      NULL,
      NULL,
      NULL,
      1.315023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.444185,
      1,
      1,
      1,
      NULL,
      NULL,
      1.134407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.061301,
      0.513849,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912001,
      0.580398,
      NULL,
      1.888035,
      2.786593,
      0.261784,
      1,
      1.940259,
      1,
      2,
      1,
      1.575663,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0.371289,
      0.135844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.409183,
      '43342',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.333886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


