set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '212',
      '14',
      38.899566,
      24,
      '3403221',
      95.942051,
      5,
      1.749378,
      0,
      '110134',
      0,
      '10- 3-1977',
      65,
      45.227695,
      1.942765,
      NULL,
      1,
      1.274697,
      NULL,
      1,
      1,
      NULL,
      0.556114,
      0,
      0,
      0,
      1.743110,
      1,
      1,
      1.526388,
      1,
      1,
      0,
      1.971044,
      1,
      0.992365,
      0,
      1,
      5.849654,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.937957,
      NULL,
      NULL,
      0.334870,
      0,
      0,
      1.959153,
      0,
      1,
      2.664179,
      NULL,
      3.193602,
      1,
      0,
      0.336809,
      0.612144,
      1,
      1,
      1.522842,
      3,
      2,
      NULL,
      NULL,
      1,
      0.524686,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.077263,
      0,
      1,
      1.772134,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1.138677,
      NULL,
      NULL,
      1,
      1.502489,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.107296,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.232075,
      NULL,
      2,
      NULL,
      0,
      1.856851,
      2.889851,
      NULL,
      NULL,
      1,
      1.423374,
      NULL,
      1.389776,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891971,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298996,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682426,
      NULL,
      NULL,
      NULL,
      NULL,
      0.806775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.164879,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.837504,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.608989,
      1.983335,
      1,
      1.024444,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      0.494116,
      1,
      1.386643,
      0,
      1,
      1.807299,
      1,
      1.853592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '03441',
      NULL,
      '',
      1.398977,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


