set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      '22',
      34.202744,
      25.602776,
      '0141004',
      100,
      0,
      1,
      2,
      '000131',
      NULL,
      NULL,
      63.045870,
      24.195139,
      NULL,
      NULL,
      0,
      1.022202,
      2.180388,
      1,
      1.125953,
      0.998994,
      0.022697,
      1,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      1.753205,
      1,
      3.239608,
      0,
      1,
      1,
      0.385322,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0.991127,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.879795,
      5,
      2.348199,
      0.234179,
      0.904220,
      3.206243,
      3.555680,
      0.590078,
      3.021183,
      0,
      0,
      0.377198,
      1.752176,
      NULL,
      1,
      2.873286,
      3,
      2,
      0.299757,
      NULL,
      0.862158,
      NULL,
      1,
      1,
      3.637758,
      0,
      NULL,
      NULL,
      0.987573,
      NULL,
      NULL,
      0.031238,
      1.737697,
      1,
      1,
      0.579138,
      0.842597,
      0,
      NULL,
      0.818485,
      0,
      0.750961,
      NULL,
      0.194972,
      NULL,
      0.448371,
      NULL,
      NULL,
      NULL,
      0.748239,
      NULL,
      0.373064,
      0.325561,
      NULL,
      1.590198,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.109274,
      1,
      3.723591,
      0.355226,
      1.725417,
      NULL,
      0.419816,
      3.161883,
      1.081751,
      1.343649,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5,
      0.498357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1.485845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.096542,
      1.468547,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.722693,
      1,
      1.702810,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.632339,
      1.211565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0.585517,
      1.674038,
      0,
      0.606078,
      1.128624,
      1,
      1.887008,
      0,
      1.662098,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.687916,
      '04021',
      '',
      '',
      0.571352,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      4.188176,
      1,
      2.352796,
      0.502852,
      3,
      1.160944,
      NULL,
      1.881858,
      3.004895);
commit;
end;
/


