set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      '01014143',
      36.000533,
      8,
      '4034443',
      46.992531,
      NULL,
      2.135465,
      0,
      NULL,
      2.823419,
      NULL,
      26.871297,
      10,
      1.201400,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.260199,
      0,
      2,
      1.188229,
      1,
      4,
      1.566980,
      1,
      NULL,
      1,
      0,
      3.176847,
      0,
      1.012547,
      1.389842,
      0,
      0.318038,
      3.194698,
      1,
      1,
      0.665274,
      0,
      1.137424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864856,
      3.895571,
      5.624832,
      NULL,
      1,
      0,
      NULL,
      1,
      3.240657,
      0,
      NULL,
      1.726359,
      1,
      3.484533,
      0,
      0.408017,
      3,
      NULL,
      3,
      NULL,
      0.008126,
      1,
      3,
      1,
      1,
      3.135736,
      0,
      NULL,
      NULL,
      1.146879,
      NULL,
      NULL,
      0,
      0,
      0.641707,
      0,
      0.503237,
      NULL,
      0.348191,
      1,
      1,
      0.820051,
      NULL,
      0.778719,
      NULL,
      1,
      0.641051,
      1,
      0.777460,
      1,
      NULL,
      NULL,
      0.681838,
      0.509093,
      0.319280,
      NULL,
      0,
      1,
      0.885959,
      1.068900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278899,
      0,
      1.548857,
      0.638929,
      0,
      4.442681,
      0,
      0,
      NULL,
      0,
      3.081776,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      6.532642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.865319,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082720,
      0.908502,
      0.920043,
      0,
      2.501008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.404997,
      5,
      1,
      0.522282,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.531915,
      2,
      1,
      0,
      0.428501,
      0.665889,
      NULL,
      3,
      1,
      0,
      0.869947,
      1.637612,
      1,
      1.556147,
      0.507155,
      0,
      NULL,
      0.596602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.326368,
      '04032',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      5.310901,
      NULL,
      2,
      1,
      NULL,
      1.125700,
      3.843511,
      1);
commit;
end;
/


