set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '424',
      '43301321',
      24.657354,
      36,
      '0331143',
      73,
      0,
      3,
      1,
      '342224',
      4.495742,
      ' 5-16-1977',
      30,
      24.017843,
      NULL,
      NULL,
      1.851330,
      0.262705,
      NULL,
      0.105639,
      NULL,
      1,
      1.447133,
      2.309886,
      NULL,
      NULL,
      4.495270,
      0,
      1,
      1.960324,
      1.863272,
      1.395588,
      NULL,
      0,
      1,
      1.696408,
      0,
      0.130224,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.085697,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      4.577121,
      3,
      0,
      0,
      0.041968,
      2,
      2,
      NULL,
      2,
      0,
      0,
      3.686136,
      NULL,
      0.478441,
      2,
      2.683742,
      3,
      0,
      0,
      0,
      5.718843,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0.050030,
      1,
      1.331743,
      0.639297,
      NULL,
      0,
      0,
      1,
      NULL,
      1.540873,
      0.970311,
      NULL,
      1.580515,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.262824,
      0.297932,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819387,
      NULL,
      1.647004,
      0,
      1.789118,
      1.618635,
      4,
      1.071809,
      NULL,
      1,
      1,
      4.367429,
      2,
      1,
      5.531497,
      1.418462,
      0,
      NULL,
      NULL,
      7.734928,
      1.091432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797096,
      0,
      1,
      0,
      1.627281,
      0.389396,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.236785,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184857,
      0,
      2.775076,
      NULL,
      NULL,
      2,
      0.470939,
      NULL,
      NULL,
      NULL,
      1.006189,
      1.579655,
      0.652646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328905,
      2,
      0,
      3.024442,
      0,
      NULL,
      NULL,
      1,
      0.296997,
      1,
      NULL,
      0.276895,
      0,
      NULL,
      0,
      0,
      1.503109,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '33420',
      '',
      '',
      0,
      '',
      '',
      '',
      0.662708,
      NULL,
      '',
      '',
      3,
      6.115112,
      NULL,
      3.701007,
      0.062728,
      0.168696,
      2,
      0.758850,
      1.549424);
commit;
end;
/


