set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      NULL,
      13.196960,
      22,
      '1120140',
      67.910025,
      4,
      2.176876,
      2,
      NULL,
      0.299729,
      NULL,
      20,
      110.276825,
      0,
      NULL,
      0.057637,
      NULL,
      2.508384,
      1.167151,
      NULL,
      1,
      1.538453,
      NULL,
      1.040806,
      0,
      0.488101,
      1,
      1,
      1.331745,
      1,
      1.092145,
      NULL,
      1,
      1,
      1.300984,
      1,
      1.986788,
      4,
      0,
      1,
      NULL,
      1.241117,
      1.560046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.790478,
      4,
      2,
      0,
      0.703030,
      3,
      0,
      NULL,
      2,
      2.373918,
      NULL,
      0.677463,
      2,
      NULL,
      1,
      3,
      NULL,
      3.601695,
      NULL,
      NULL,
      0.989654,
      3.050759,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.633688,
      NULL,
      1.344907,
      0.555010,
      1.396881,
      1.944699,
      NULL,
      0,
      NULL,
      0.167461,
      0.201204,
      0,
      0,
      0,
      1.143375,
      NULL,
      0.628810,
      0,
      NULL,
      1.919950,
      0.184217,
      1.997529,
      NULL,
      0,
      0,
      NULL,
      2.991857,
      NULL,
      NULL,
      NULL,
      NULL,
      1.397524,
      1.640982,
      NULL,
      1.563219,
      NULL,
      4.232606,
      6,
      NULL,
      1,
      1,
      NULL,
      5.970542,
      0.689363,
      0,
      0.265508,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.625498,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953673,
      0.226655,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.473344,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959118,
      3.838507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002302,
      0,
      1.983151,
      1,
      3,
      0.924132,
      0,
      1.518196,
      0.403359,
      2.056003,
      NULL,
      0.635156,
      0,
      1,
      0,
      1,
      1,
      0.527978,
      1,
      0.527666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '20444',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.220368,
      NULL,
      '',
      '',
      NULL,
      1,
      0.366697,
      3,
      NULL,
      2.302897,
      NULL,
      3,
      3.561704);
commit;
end;
/


