set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '240',
      NULL,
      NULL,
      22,
      '4140342',
      NULL,
      5,
      0,
      2,
      '120131',
      NULL,
      ' 6- 0-1976',
      17.429019,
      18.791906,
      1,
      NULL,
      1,
      0,
      0,
      1.752378,
      1.971997,
      0.955403,
      1,
      1.024652,
      0,
      1,
      5.693673,
      NULL,
      1,
      1.263982,
      0.307000,
      0.620475,
      4.520748,
      1.975862,
      NULL,
      0.629035,
      0,
      1.123974,
      0.623220,
      0,
      0.961848,
      0,
      1,
      0,
      NULL,
      NULL,
      0.973329,
      NULL,
      NULL,
      3.751634,
      3,
      NULL,
      3,
      1.988278,
      0,
      NULL,
      3,
      0.461114,
      1,
      0,
      1,
      1,
      3.812533,
      NULL,
      1.701569,
      2.220873,
      3,
      NULL,
      1.327006,
      1,
      1,
      4.611384,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.220032,
      0,
      0.891157,
      0.767713,
      0,
      NULL,
      0.439335,
      0.070703,
      1,
      1.508089,
      NULL,
      0.266168,
      1,
      0,
      NULL,
      0,
      1.384811,
      0,
      0.023172,
      NULL,
      0.808818,
      0,
      1,
      1.423711,
      0,
      NULL,
      0,
      0.051479,
      0.169718,
      0.831398,
      0,
      0,
      1,
      1.603110,
      NULL,
      0,
      1,
      3.271681,
      1,
      2,
      1.746999,
      1,
      2,
      NULL,
      0,
      1.261275,
      1,
      0.117536,
      0.993673,
      NULL,
      NULL,
      0,
      1.078181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574625,
      1.406740,
      0,
      1,
      0.541102,
      1.888681,
      0,
      0.166181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.300090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.481643,
      2.062378,
      1,
      0.451276,
      1,
      0,
      NULL,
      NULL,
      1.624695,
      NULL,
      1.540362,
      0,
      1.388149,
      1.599881,
      NULL,
      NULL,
      1,
      0,
      0.263072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.518004,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      3.578915,
      4.979715,
      3,
      0,
      3.309497,
      3,
      2,
      3,
      4.631781);
commit;
end;
/


