set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      '13200434',
      1.624636,
      69,
      '0143134',
      NULL,
      NULL,
      0.493988,
      NULL,
      '034200',
      5.759411,
      ' 5-21-1997',
      NULL,
      37,
      1,
      NULL,
      3,
      1.347415,
      1.959793,
      1,
      0,
      NULL,
      0.119381,
      NULL,
      0,
      1.417002,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.330059,
      0,
      0,
      NULL,
      1.960322,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.035634,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.972500,
      1.214155,
      4,
      1.403426,
      1.482816,
      1,
      1,
      1.655329,
      1,
      NULL,
      3.687475,
      NULL,
      0,
      2.020291,
      1.364046,
      1.276972,
      NULL,
      0.659683,
      NULL,
      0,
      1.918589,
      1,
      2,
      1,
      1,
      2.806114,
      0.530782,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.100082,
      0,
      1,
      1.358558,
      NULL,
      1.462016,
      NULL,
      NULL,
      0.153181,
      1,
      NULL,
      1,
      1,
      0,
      0.744652,
      0.291808,
      1,
      NULL,
      1.749851,
      1.904201,
      1.626654,
      1,
      NULL,
      0,
      0.122855,
      1.357005,
      0,
      1,
      1.388841,
      1,
      0.804111,
      NULL,
      0.886217,
      1.149961,
      0.762229,
      3.776268,
      NULL,
      3,
      NULL,
      0,
      3.670848,
      3.602490,
      2,
      0,
      0.799644,
      1,
      0.232081,
      NULL,
      NULL,
      7.528466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.838679,
      1,
      1.755641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.546097,
      1.239977,
      1,
      NULL,
      NULL,
      NULL,
      0.168294,
      NULL,
      1.473087,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.394081,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802733,
      3,
      1,
      2.344108,
      NULL,
      NULL,
      0.148627,
      1,
      0.822034,
      3.956373,
      0,
      1.288384,
      1.504502,
      1,
      1,
      0.503498,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '22431',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1.067308,
      2.828442,
      1,
      1,
      NULL,
      0,
      1.529389,
      2,
      0.018887);
commit;
end;
/


