set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '103',
      '22442124',
      76,
      40.654909,
      NULL,
      NULL,
      5,
      3,
      3,
      '210014',
      4.976693,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.104675,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.341014,
      1.478352,
      1.683415,
      0.681054,
      NULL,
      1,
      1,
      NULL,
      1,
      1.882371,
      0,
      1.256962,
      NULL,
      NULL,
      1.799165,
      0.837799,
      5,
      0,
      NULL,
      1.191937,
      0.580805,
      0.265357,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      NULL,
      2,
      0,
      1,
      3,
      NULL,
      0,
      1,
      2.965925,
      1.903550,
      NULL,
      0,
      1,
      1,
      NULL,
      2,
      1.537712,
      0,
      0.618735,
      1.412817,
      5.894086,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584015,
      NULL,
      1.119351,
      0.350765,
      NULL,
      1.904357,
      1.180033,
      0.356046,
      0,
      0.515876,
      NULL,
      0,
      0.815990,
      1.464119,
      NULL,
      0,
      1,
      0.655925,
      1,
      NULL,
      0.791895,
      0.329415,
      0.368409,
      0.427100,
      0,
      0,
      NULL,
      1.218658,
      0.827004,
      NULL,
      1,
      NULL,
      1.411489,
      NULL,
      1,
      0.133351,
      1,
      4,
      0.913274,
      0,
      NULL,
      0,
      2,
      4.330975,
      2.740720,
      0.355599,
      NULL,
      0,
      1.806808,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959466,
      1,
      0,
      1,
      1,
      0.940457,
      0.583032,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0.433175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.695141,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.984366,
      2.071213,
      3.306432,
      0.527878,
      0.741318,
      NULL,
      0,
      NULL,
      0.011251,
      1,
      1.951662,
      0,
      1.697638,
      1.200070,
      NULL,
      NULL,
      1,
      0.309690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '01233',
      '',
      '',
      1.484761,
      '',
      '',
      '',
      0.431256,
      '',
      NULL,
      '',
      3,
      0.705217,
      3.287437,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2);
commit;
end;
/


