set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '110',
      NULL,
      28.038778,
      30.660219,
      NULL,
      182.224593,
      1,
      3,
      2,
      '142104',
      1.662615,
      ' 6-18-1980',
      NULL,
      55.826666,
      0,
      NULL,
      1.012941,
      0.959576,
      NULL,
      0,
      0,
      0,
      NULL,
      2.188151,
      0.294172,
      NULL,
      0.883999,
      0,
      1.741063,
      0.408357,
      1.766665,
      1.425459,
      NULL,
      NULL,
      1,
      1.807011,
      0.955233,
      1.451891,
      4,
      0,
      NULL,
      0,
      0.967799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.256275,
      1.577778,
      NULL,
      0.396770,
      1.776617,
      1.518535,
      0.045649,
      3.842434,
      2,
      NULL,
      0.723323,
      1,
      0,
      NULL,
      0.257641,
      NULL,
      0,
      0.188167,
      3,
      1.524995,
      NULL,
      1.964934,
      2,
      NULL,
      1,
      2,
      1.277613,
      NULL,
      NULL,
      1.925804,
      NULL,
      NULL,
      1.792495,
      0,
      0,
      NULL,
      0.537342,
      0,
      0.684805,
      0.326287,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0.463212,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1.616541,
      0,
      NULL,
      1.911268,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.810220,
      0,
      0,
      0,
      0.471668,
      NULL,
      1.750360,
      4,
      NULL,
      3.649832,
      NULL,
      NULL,
      0.149661,
      1,
      0,
      0.923028,
      NULL,
      NULL,
      7.635092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.690662,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.218794,
      NULL,
      1.835654,
      0.467237,
      0,
      3.504038,
      2.398381,
      3.607177,
      1.931205,
      NULL,
      NULL,
      NULL,
      4.755532,
      1.293434,
      0.123371,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.882160,
      1.626147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276688,
      NULL,
      NULL,
      0,
      1,
      1.382557,
      0,
      NULL,
      1.930295,
      0.484282,
      1,
      1.362414,
      1.101044,
      0,
      0.682645,
      1,
      0.951874,
      0,
      0,
      1.414296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.719933,
      0.609430,
      NULL,
      0.152922,
      NULL,
      4,
      3.910274,
      2.240253,
      3.485449);
commit;
end;
/


