set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0204',
      '13220110',
      NULL,
      45.006950,
      NULL,
      122.303422,
      2,
      0,
      NULL,
      '003111',
      4,
      ' 6- 0-1974',
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.220582,
      0,
      1.575374,
      3,
      1,
      NULL,
      NULL,
      1,
      1.902468,
      NULL,
      NULL,
      0,
      0.799908,
      0.654703,
      1,
      0,
      NULL,
      NULL,
      3.589935,
      NULL,
      0.298660,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5.037742,
      NULL,
      NULL,
      1.404789,
      1,
      2,
      NULL,
      2,
      0,
      3.542896,
      0.821699,
      3,
      1,
      0.209085,
      3.892550,
      3.291455,
      1,
      1,
      0.136796,
      NULL,
      0,
      0,
      0,
      2,
      0.809203,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.244873,
      0.657427,
      NULL,
      0.739095,
      1.973078,
      0,
      1,
      NULL,
      0,
      1.331315,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.145952,
      NULL,
      0.537957,
      NULL,
      1,
      NULL,
      1.676593,
      1.907839,
      NULL,
      2.439872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.124309,
      1,
      1.306816,
      1,
      0.762307,
      NULL,
      4.894341,
      NULL,
      0,
      0.567677,
      0,
      0.590533,
      1,
      0,
      0,
      NULL,
      NULL,
      6.728233,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.163927,
      2,
      1,
      1.177886,
      0.816615,
      1,
      0.366434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487943,
      0,
      1,
      5,
      1,
      0,
      1.479212,
      NULL,
      NULL,
      NULL,
      1.041117,
      1,
      1.770945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829290,
      2,
      1.246007,
      NULL,
      2.423609,
      0.245385,
      0.128674,
      1.350006,
      1,
      1,
      1.329410,
      NULL,
      NULL,
      0,
      0.300751,
      0.123612,
      1.902367,
      0.828594,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.889961,
      '23223',
      '',
      '',
      1.509045,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      5.246234,
      0,
      1.586689,
      1,
      0,
      1,
      2,
      1,
      1);
commit;
end;
/


