set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4414',
      '42012110',
      NULL,
      NULL,
      '0443220',
      164.331453,
      3,
      3,
      1,
      '033301',
      3.098545,
      ' 2- 8-1982',
      12.592220,
      205.270521,
      1,
      NULL,
      0,
      0.897721,
      NULL,
      NULL,
      NULL,
      0.472130,
      1,
      1,
      0,
      0.830363,
      0,
      1.361378,
      1.480261,
      3,
      NULL,
      NULL,
      0,
      1.141646,
      0,
      1.206965,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.459158,
      1.355430,
      0,
      0,
      1,
      0.902029,
      1,
      NULL,
      0.228479,
      2.207695,
      1,
      0,
      0.680780,
      NULL,
      0.835106,
      NULL,
      0.197799,
      1,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      1.952891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.212974,
      NULL,
      0,
      1.718981,
      1,
      0,
      1.660919,
      1.491292,
      0.126177,
      0,
      1,
      1,
      0,
      0.480949,
      0,
      NULL,
      0.939346,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.473730,
      1.754610,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.720463,
      0.724998,
      1.996005,
      0,
      NULL,
      3,
      1,
      2,
      4,
      0,
      0.557595,
      NULL,
      NULL,
      1.709504,
      0.660721,
      NULL,
      1.446089,
      NULL,
      NULL,
      5,
      1.358190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.465460,
      1.140018,
      NULL,
      NULL,
      NULL,
      1,
      1.918705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.040407,
      NULL,
      NULL,
      NULL,
      1,
      1.111947,
      NULL,
      1.236389,
      1,
      0,
      0.639506,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233877,
      2.381818,
      NULL,
      0.982382,
      2.676668,
      0,
      0.052281,
      NULL,
      NULL,
      3,
      0.606093,
      NULL,
      NULL,
      0.450383,
      1,
      1.491041,
      0.766793,
      NULL,
      1.612831,
      1.069354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.860835,
      '43213',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.363581,
      NULL,
      NULL,
      '',
      3,
      1,
      NULL,
      3.087125,
      3,
      NULL,
      3.184744,
      2.325952,
      2);
commit;
end;
/


