set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0143',
      '43120112',
      69,
      18,
      '1441000',
      232.683320,
      NULL,
      3.938632,
      1,
      NULL,
      4,
      '10-17-1975',
      57,
      4,
      0.479200,
      NULL,
      1,
      NULL,
      0.501506,
      1.403378,
      1,
      NULL,
      0,
      2,
      1,
      1.435080,
      1,
      1,
      1,
      1,
      1.144396,
      1,
      4,
      NULL,
      0,
      0.348531,
      1.732312,
      1,
      1.320867,
      1,
      NULL,
      3.336415,
      1.301566,
      1,
      NULL,
      NULL,
      1.043573,
      NULL,
      NULL,
      1.975123,
      1,
      2.353593,
      NULL,
      0.370492,
      0,
      0,
      1,
      0.016815,
      2.579579,
      1.101371,
      1.702748,
      1,
      3.217737,
      1,
      1.188051,
      1.439269,
      3.190362,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      1.596019,
      0,
      NULL,
      NULL,
      0.996298,
      NULL,
      NULL,
      0.636755,
      NULL,
      1.869665,
      1,
      0,
      1.076609,
      NULL,
      1,
      0,
      0.223988,
      1,
      NULL,
      NULL,
      0.719513,
      1,
      0.056617,
      1.448319,
      NULL,
      1.633765,
      NULL,
      0.516275,
      0.909559,
      NULL,
      NULL,
      0.460196,
      1,
      NULL,
      0.853964,
      1.355638,
      1,
      0.521054,
      NULL,
      NULL,
      NULL,
      0.600618,
      0,
      0.112669,
      1.635027,
      NULL,
      0,
      3.451705,
      0.223722,
      1.187971,
      6,
      1,
      NULL,
      0,
      NULL,
      1.491473,
      NULL,
      NULL,
      8.925954,
      1.929756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1.785747,
      0.355345,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.979868,
      0.265514,
      1.957968,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      0,
      0.210008,
      1.835384,
      1,
      1,
      1,
      0.842787,
      1,
      NULL,
      0.017718,
      NULL,
      0.720262,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.352133,
      '12141',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2.855711,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1.117459);
commit;
end;
/


