set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2423',
      '21034411',
      64,
      74.394072,
      NULL,
      125.958185,
      2,
      1.321776,
      2,
      NULL,
      4.114539,
      ' 9-20-1996',
      6,
      16,
      1.541205,
      NULL,
      0,
      0,
      1.629932,
      0,
      1.446792,
      0,
      1.965970,
      0.889321,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      NULL,
      0,
      0.033902,
      0,
      0.600651,
      0,
      1.539134,
      1.454672,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.911075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738575,
      1,
      1.048458,
      NULL,
      1.658713,
      1.603266,
      1.324564,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1.783510,
      1.592070,
      1,
      1.496696,
      NULL,
      0.825896,
      NULL,
      1,
      1,
      NULL,
      1.024099,
      1.634853,
      0.332657,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170792,
      0.691353,
      0.604235,
      1,
      NULL,
      0.602106,
      0,
      3.442128,
      NULL,
      NULL,
      2.906097,
      7.156568,
      NULL,
      0.742096,
      1.571543,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186108,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228503,
      1,
      2.024549,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.591409,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751111,
      3.028004,
      2,
      NULL,
      NULL,
      0.159440,
      0,
      0.264060,
      0.152883,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0.489313,
      0.573804,
      0.948770,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '44213',
      '',
      NULL,
      0.789324,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      2,
      1.391738,
      1.266482,
      2.288967,
      1.746699,
      3.561085,
      3.638082,
      NULL,
      3.094746);
commit;
end;
/


