set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2343',
      '34233100',
      37,
      69.023837,
      '4420432',
      NULL,
      3,
      2.527047,
      2,
      NULL,
      1.316267,
      ' 6-24-1994',
      63.990209,
      3,
      0.772487,
      NULL,
      0,
      1.307521,
      1.474892,
      0.865915,
      0.985665,
      NULL,
      0.657258,
      2.774829,
      1,
      NULL,
      3,
      NULL,
      0.647635,
      0,
      0,
      0.163342,
      4,
      0,
      4,
      1,
      1.374519,
      0,
      0,
      1,
      3.085300,
      0.234224,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.359532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.614914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.596606,
      0.527423,
      0,
      1.805922,
      NULL,
      1.487096,
      1,
      0.527481,
      1,
      0.533065,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      3.050441,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.373163,
      NULL,
      NULL,
      1,
      5,
      5.383773,
      5,
      4,
      1.724321,
      1.282480,
      1,
      3,
      0,
      1.610865,
      1.590170,
      1.707080,
      NULL,
      NULL,
      6.865421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293927,
      0,
      NULL,
      NULL,
      1.527544,
      1,
      1.245777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.722510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.141553,
      NULL,
      NULL,
      NULL,
      1.706297,
      NULL,
      2,
      0,
      1.064144,
      NULL,
      0.935389,
      NULL,
      NULL,
      NULL,
      0.878016,
      0.635852,
      1.771174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.557723,
      1.723883,
      3,
      0,
      0,
      0.278693,
      0,
      2.284061,
      NULL,
      1.220277,
      0,
      0.227012,
      NULL,
      NULL,
      1,
      1,
      0.896275,
      0.395911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.752288,
      '34313',
      '',
      '',
      1.470558,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      6,
      3.914353,
      NULL,
      3,
      0,
      NULL,
      0,
      1.767434);
commit;
end;
/


