set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '343',
      '30',
      34.229170,
      2,
      '3410410',
      1.441866,
      NULL,
      NULL,
      2,
      '232010',
      NULL,
      ' 3-25-1995',
      118.491335,
      1,
      NULL,
      NULL,
      2,
      0.139854,
      1.041074,
      1,
      NULL,
      0.126130,
      0,
      1,
      1,
      1,
      1.467141,
      0.813146,
      0.907981,
      1.147130,
      1,
      NULL,
      0.470751,
      0.272213,
      2.253744,
      2,
      NULL,
      1,
      2.817230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.375687,
      NULL,
      0,
      NULL,
      0,
      0,
      2.740845,
      1,
      3.998404,
      1.515041,
      3,
      1,
      2,
      1,
      2,
      0.931978,
      NULL,
      NULL,
      1.434139,
      1,
      1.444807,
      5.819637,
      NULL,
      1,
      1.472721,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1,
      1,
      1.163036,
      0,
      0,
      0.231628,
      1.268547,
      NULL,
      0.356084,
      0,
      0.763366,
      NULL,
      0,
      0.931512,
      0,
      1.366979,
      NULL,
      NULL,
      3,
      0.827178,
      1,
      3,
      0.966514,
      4.371373,
      0,
      7,
      5.042279,
      NULL,
      0,
      6,
      6.914422,
      2,
      5.876356,
      0.950423,
      7.165596,
      1.735456,
      2,
      8,
      NULL,
      9.498431,
      4.685652,
      11.712397,
      7.855767,
      5,
      NULL,
      3.912194,
      0,
      1.062299,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218544,
      NULL,
      NULL,
      0,
      NULL,
      0.308016,
      0.772546,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.050219,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.559275,
      NULL,
      1.579224,
      0,
      3.912413,
      NULL,
      NULL,
      1.823923,
      NULL,
      NULL,
      NULL,
      1.226963,
      NULL,
      9.362535,
      NULL,
      1,
      NULL,
      0.470853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.595295,
      NULL,
      NULL,
      3.183631,
      0,
      0,
      NULL,
      NULL,
      3.787356,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.446088,
      0,
      0.203486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '14310',
      '',
      NULL,
      0,
      '',
      NULL,
      NULL,
      2,
      '1004',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


