set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      '13',
      NULL,
      13.186001,
      '2440214',
      4.323925,
      NULL,
      0.347780,
      1,
      '044221',
      0,
      ' 4- 0-1996',
      23,
      32.956927,
      NULL,
      NULL,
      NULL,
      3,
      1.118985,
      NULL,
      NULL,
      1.152030,
      NULL,
      1.673399,
      0,
      1,
      NULL,
      0,
      1.868083,
      NULL,
      0.821716,
      0.619762,
      0.696142,
      NULL,
      0.570852,
      NULL,
      NULL,
      0.488535,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607018,
      NULL,
      3.458166,
      3,
      NULL,
      0,
      3.823461,
      1.083980,
      1,
      NULL,
      0.500697,
      3.163367,
      1,
      0.649377,
      1.644914,
      2,
      1,
      0,
      1.285582,
      0,
      NULL,
      0.105735,
      7.605791,
      1,
      2,
      1.736993,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.447822,
      0,
      3,
      1,
      1,
      0.267811,
      0.999626,
      1.800012,
      1.129542,
      0.902003,
      1,
      0.947110,
      1.407426,
      0.694430,
      NULL,
      NULL,
      1,
      NULL,
      1.910862,
      6.420411,
      0,
      0,
      0,
      0,
      2,
      1,
      NULL,
      0,
      3,
      3.255945,
      6,
      6.858224,
      6.194332,
      0,
      1,
      3.232807,
      NULL,
      5,
      5,
      NULL,
      7.341265,
      3.826868,
      5,
      5,
      1,
      2.640086,
      0.698196,
      1.433217,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150911,
      0.444728,
      1,
      NULL,
      0.529485,
      1.605544,
      1.398174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.304952,
      1.101995,
      NULL,
      NULL,
      NULL,
      9.303797,
      7,
      1.439161,
      0.342492,
      NULL,
      NULL,
      NULL,
      0.200055,
      1.450704,
      6,
      4.740141,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.808243,
      1.513517,
      2,
      3.691194,
      NULL,
      1.020464,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0.938511,
      0.621902,
      1.180218,
      0.683667,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.636891,
      '43200',
      '',
      NULL,
      0,
      '',
      '',
      '',
      3.761168,
      '0300',
      '',
      '',
      NULL,
      NULL,
      1.862367,
      0.218320,
      3,
      3.381155,
      2.555149,
      0,
      1);
commit;
end;
/


