set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '313',
      '40033003',
      26.822324,
      43,
      '0441142',
      2.632277,
      5,
      3.138868,
      2,
      '330302',
      3.181009,
      ' 2-17-1976',
      135,
      157,
      NULL,
      NULL,
      1,
      NULL,
      0.572035,
      0.889235,
      NULL,
      3,
      1,
      NULL,
      1.710365,
      1,
      4,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      1.806445,
      1.489165,
      3.654169,
      1,
      1.823120,
      1.786570,
      1.515573,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.315465,
      2,
      3,
      3,
      NULL,
      1,
      1,
      NULL,
      1.059636,
      NULL,
      1,
      1,
      1.124292,
      0.760898,
      0.878047,
      3.625034,
      NULL,
      1,
      0,
      0.916870,
      0,
      1.547067,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.465894,
      0.533156,
      3,
      NULL,
      NULL,
      NULL,
      1.309947,
      0,
      1,
      1,
      0.198976,
      0,
      0,
      1.216358,
      1,
      0,
      0,
      NULL,
      1.802980,
      7.474152,
      1.533330,
      1,
      NULL,
      1,
      9.962642,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177173,
      5.803145,
      2.451914,
      0.759841,
      1.219545,
      3.638883,
      1,
      2.588918,
      5,
      NULL,
      3.959992,
      NULL,
      11.543273,
      7.971126,
      3,
      6,
      1.548660,
      1,
      0.200030,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232963,
      2,
      2.645753,
      1.553470,
      1,
      1.533618,
      6.350271,
      2,
      1.111821,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      7,
      1.241214,
      NULL,
      1.765681,
      NULL,
      NULL,
      NULL,
      0.222798,
      4,
      0.539587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.449603,
      1.600114,
      3.050355,
      NULL,
      0.364322,
      2,
      1,
      0,
      3,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0.900652,
      1,
      NULL,
      1.451732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '04130',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      '4010',
      '',
      NULL,
      NULL,
      0.888989,
      2.556743,
      1.585432,
      1,
      1.932761,
      NULL,
      0,
      NULL);
commit;
end;
/


