set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22043300',
      NULL,
      12,
      NULL,
      16,
      NULL,
      NULL,
      0,
      '131221',
      2,
      ' 7-20-1990',
      187,
      112.226388,
      0.317853,
      NULL,
      2.020913,
      1.273026,
      0,
      NULL,
      1.229899,
      3,
      0,
      1.182175,
      1,
      1,
      1,
      1,
      1.969195,
      1.701756,
      1.504791,
      1.138675,
      NULL,
      NULL,
      3.041759,
      NULL,
      1,
      1,
      5,
      0,
      1.532547,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.416126,
      NULL,
      NULL,
      6.101415,
      NULL,
      NULL,
      0,
      NULL,
      1.575172,
      1,
      1,
      1.549310,
      0,
      3,
      NULL,
      NULL,
      3.242845,
      2,
      0.488020,
      1,
      0,
      2,
      NULL,
      0.610121,
      3,
      NULL,
      NULL,
      NULL,
      0.462705,
      1.607987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041372,
      1,
      0,
      1.561203,
      0.608758,
      0.930775,
      1.251189,
      0.146117,
      1,
      1.606731,
      0,
      NULL,
      1,
      1,
      0.817991,
      NULL,
      NULL,
      0.208306,
      1,
      NULL,
      0,
      8,
      1,
      1.646986,
      1.334491,
      0,
      9,
      1,
      6.858576,
      NULL,
      NULL,
      0,
      NULL,
      2,
      6,
      4.265375,
      3.749760,
      4.459619,
      6.535419,
      3.563419,
      7.580785,
      7.152345,
      2.101858,
      9.390587,
      7,
      2,
      2,
      1.084234,
      NULL,
      1,
      NULL,
      0,
      0.041619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973110,
      0,
      1,
      0.611280,
      NULL,
      0.010182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740602,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.117060,
      1,
      0.281397,
      1.788563,
      NULL,
      NULL,
      1.669539,
      NULL,
      NULL,
      NULL,
      1.690544,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514802,
      0.926898,
      NULL,
      0,
      NULL,
      3,
      0,
      1.520360,
      1.085424,
      0.852395,
      NULL,
      1,
      0,
      0.072405,
      NULL,
      NULL,
      1.422286,
      1.373489,
      0.703900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '03442',
      '',
      '',
      0.822292,
      NULL,
      NULL,
      NULL,
      2,
      '43412',
      '',
      '',
      1.256480,
      2,
      0.280293,
      0,
      1.510658,
      NULL,
      NULL,
      NULL,
      3);
commit;
end;
/


