set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '324',
      '01242012',
      NULL,
      3.169388,
      '0200011',
      35,
      4,
      2.605377,
      3,
      '321223',
      NULL,
      ' 5- 9-1987',
      NULL,
      247.085798,
      1.836187,
      NULL,
      0.426816,
      NULL,
      0.727124,
      1,
      0,
      NULL,
      1,
      2,
      2,
      0,
      4.860993,
      0.396216,
      NULL,
      0.061357,
      0.406065,
      NULL,
      NULL,
      4.899187,
      1.605420,
      1.262186,
      NULL,
      0,
      NULL,
      1,
      3.423695,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.281372,
      NULL,
      NULL,
      4.766916,
      0,
      6.665817,
      1,
      1,
      0.865256,
      0,
      NULL,
      1,
      3.446401,
      1.356098,
      2.203526,
      0,
      0.997777,
      3,
      3.123279,
      0.947946,
      0,
      0,
      0.645931,
      1.542048,
      0,
      NULL,
      1,
      2,
      0,
      1.921730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.780357,
      NULL,
      NULL,
      1.061454,
      0,
      0,
      0.444637,
      NULL,
      1,
      1.961725,
      0.395443,
      1.587839,
      3.555052,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.998791,
      4.865559,
      4,
      NULL,
      0,
      3.433077,
      1,
      2.046430,
      6,
      7,
      6.293666,
      4.546683,
      2.737969,
      6.292632,
      5,
      1.354822,
      3.183749,
      5,
      3,
      NULL,
      3.600811,
      2,
      8,
      4.697059,
      NULL,
      5.433462,
      NULL,
      NULL,
      1.866960,
      0.021973,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595962,
      1.413976,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662495,
      2.199226,
      0.973395,
      NULL,
      NULL,
      NULL,
      0,
      1.799210,
      NULL,
      0,
      NULL,
      2,
      1.370573,
      NULL,
      NULL,
      NULL,
      1.455048,
      4.056310,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.403635,
      3,
      NULL,
      0.021636,
      NULL,
      NULL,
      1,
      1.470210,
      0.751762,
      2,
      0.451047,
      0.883025,
      1.338786,
      0,
      NULL,
      1.590134,
      1.792565,
      0.341058,
      0.010268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '21144',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '32342',
      '',
      '',
      5,
      2,
      2,
      3.968035,
      0.405930,
      NULL,
      1,
      2.314561,
      2);
commit;
end;
/


