set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '343',
      NULL,
      7,
      21.233407,
      '2233030',
      97,
      0,
      0.728668,
      3,
      '344104',
      4,
      NULL,
      6.165668,
      NULL,
      1,
      NULL,
      NULL,
      1.778980,
      1,
      0.195323,
      NULL,
      2.244950,
      0,
      1.757200,
      1.130250,
      0,
      3.185288,
      1.201180,
      0.762084,
      NULL,
      1.432086,
      0,
      2.062742,
      2,
      3.521505,
      0.918141,
      1.174331,
      0.203499,
      7.576111,
      0,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      0.066555,
      NULL,
      NULL,
      6,
      7,
      0.929747,
      NULL,
      2,
      3.174544,
      3.196004,
      1,
      2.168930,
      0.436865,
      NULL,
      2,
      2.267081,
      1,
      0,
      NULL,
      NULL,
      0,
      2.999643,
      0,
      1,
      NULL,
      5,
      0,
      2,
      3.496588,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.045702,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.984406,
      0.741203,
      0.989279,
      1,
      NULL,
      0,
      6,
      2,
      1.835626,
      5.130937,
      NULL,
      5.038204,
      NULL,
      0.157352,
      5.176540,
      2,
      NULL,
      5,
      NULL,
      0,
      NULL,
      3,
      NULL,
      5,
      4,
      2.336144,
      5.710647,
      1.454855,
      6,
      2.218552,
      5.574316,
      3,
      NULL,
      3.110561,
      1,
      0,
      NULL,
      0.252618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.140536,
      NULL,
      1,
      1,
      1.946695,
      0,
      0,
      0.676678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.302041,
      5.250039,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959286,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.538876,
      2,
      NULL,
      0,
      1,
      2.553374,
      0.994502,
      1.265481,
      NULL,
      0.906073,
      NULL,
      1,
      1.199153,
      NULL,
      0.156957,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '33140',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      NULL,
      '22032',
      '',
      '',
      4.441144,
      1.608650,
      NULL,
      0,
      NULL,
      3.469772,
      NULL,
      3,
      2.542362);
commit;
end;
/


