set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      NULL,
      52,
      NULL,
      '0142231',
      36.636302,
      NULL,
      NULL,
      3,
      '024233',
      1,
      ' 9- 8-1989',
      66.542032,
      115,
      0.781440,
      NULL,
      1.022773,
      0.665482,
      1.035307,
      1.140806,
      NULL,
      2.228255,
      1.588389,
      2.634095,
      NULL,
      1,
      1.562549,
      1.860154,
      1.696182,
      0,
      1,
      NULL,
      NULL,
      1.492924,
      7.728207,
      NULL,
      1,
      1.088302,
      NULL,
      1,
      5,
      1,
      NULL,
      0.737467,
      NULL,
      NULL,
      0.490698,
      NULL,
      NULL,
      NULL,
      NULL,
      3.152576,
      0.539622,
      0.289003,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0.442888,
      0.967733,
      1,
      0,
      0,
      2.101381,
      2.524960,
      1.158091,
      1,
      2,
      8,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1.295163,
      NULL,
      NULL,
      1.656673,
      0,
      0.637929,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0.832050,
      NULL,
      1,
      1.236090,
      1.606620,
      NULL,
      0.830952,
      2,
      3.281303,
      3.114128,
      NULL,
      0.676532,
      8,
      0,
      6.851961,
      4.725810,
      2.927245,
      NULL,
      NULL,
      5.103566,
      5,
      0,
      2.482305,
      3.255511,
      3,
      3,
      2.122302,
      6.685038,
      4.324987,
      3.751008,
      0.573595,
      3,
      1.956118,
      7.734442,
      1.615136,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921294,
      1.634928,
      1,
      1,
      0.820336,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1.195565,
      NULL,
      6,
      2,
      0.038227,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.696439,
      0.279899,
      0.476726,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.485001,
      7.268615,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.428754,
      2,
      2,
      0.609273,
      NULL,
      2,
      NULL,
      0.910487,
      0.546068,
      0,
      0.900819,
      0.769645,
      1,
      0.905661,
      1,
      1.569698,
      1,
      NULL,
      1.140700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '11210',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '13012',
      '',
      '',
      4,
      0,
      1,
      0,
      NULL,
      NULL,
      1.602083,
      NULL,
      1.352825);
commit;
end;
/


