set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21230142',
      61.177416,
      3,
      '1303314',
      4.898257,
      2,
      2.303121,
      1,
      '302400',
      1.232311,
      ' 6-21-1980',
      11,
      74.312709,
      1.084696,
      NULL,
      3.817264,
      2.138091,
      0,
      0.667964,
      3.712408,
      1.813178,
      2,
      1,
      3.038766,
      0.538102,
      3,
      1.939025,
      1,
      1,
      NULL,
      0.178724,
      5.795891,
      0,
      0.709458,
      2,
      0.197333,
      2,
      4.713099,
      1,
      0,
      0,
      3.866246,
      0.833564,
      NULL,
      NULL,
      0.945338,
      NULL,
      NULL,
      0.884743,
      10.452451,
      0.876398,
      2,
      0.538855,
      1.669800,
      2,
      NULL,
      0.527317,
      0,
      0,
      2.044329,
      1,
      1.212039,
      1.949747,
      1,
      NULL,
      0,
      0,
      1.927526,
      1.950565,
      1,
      1,
      1,
      1,
      2.083679,
      1,
      NULL,
      NULL,
      0.805134,
      NULL,
      NULL,
      1.800731,
      NULL,
      1.162831,
      1,
      NULL,
      0.498663,
      NULL,
      0,
      1,
      0.769674,
      1,
      1,
      0.677600,
      1.878353,
      0.419310,
      0,
      1.292147,
      1.987217,
      1,
      NULL,
      1.332615,
      2,
      0.567082,
      NULL,
      5,
      1.957088,
      2,
      1.562607,
      5.320270,
      7.232993,
      4.390953,
      NULL,
      0,
      NULL,
      9,
      0,
      NULL,
      3.566158,
      NULL,
      3,
      6.886740,
      3.577834,
      3,
      8,
      5.517799,
      0,
      7,
      1,
      NULL,
      1,
      0.334780,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801064,
      1,
      0,
      1,
      1,
      1.280362,
      NULL,
      0.913134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6.169202,
      2.004230,
      1.428245,
      0.290437,
      1.507706,
      9.386922,
      1,
      2.704205,
      1,
      NULL,
      NULL,
      NULL,
      0.113971,
      NULL,
      7,
      1,
      0.481947,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.257310,
      1,
      0.702190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0.255477,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1.700743,
      1.525114,
      NULL,
      0.331771,
      1,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '40040',
      '',
      '',
      1.509172,
      '',
      '',
      '',
      1.678246,
      '24232',
      '',
      '',
      NULL,
      2.797320,
      NULL,
      3,
      2.609982,
      2,
      1.020951,
      NULL,
      2);
commit;
end;
/


