set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '03211314',
      NULL,
      38,
      '3434344',
      37,
      NULL,
      2.486836,
      0,
      '114222',
      NULL,
      '10-29-1996',
      NULL,
      50.006516,
      1,
      NULL,
      NULL,
      1,
      1,
      0.911620,
      NULL,
      3.391324,
      NULL,
      2.845464,
      NULL,
      NULL,
      5,
      0.848336,
      0.694679,
      1,
      0,
      1,
      1,
      2,
      1.756552,
      NULL,
      0.159609,
      1.217778,
      0.338801,
      1,
      2,
      0,
      1.940741,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.523318,
      NULL,
      NULL,
      0,
      0,
      2,
      3.292976,
      3.083818,
      1.403820,
      2,
      2,
      0,
      2.817184,
      NULL,
      1,
      NULL,
      NULL,
      2.983907,
      0.669730,
      0,
      1.284240,
      0.368633,
      0,
      0,
      5.509340,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.787387,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      1.670934,
      1,
      1.687642,
      1.488554,
      0.590296,
      1,
      NULL,
      1.544192,
      3.316947,
      3.080962,
      4.443730,
      1.348662,
      NULL,
      2.028628,
      0.715314,
      6,
      NULL,
      0.189256,
      8.380383,
      NULL,
      NULL,
      7.757378,
      3.293641,
      1,
      NULL,
      6,
      0,
      0,
      NULL,
      NULL,
      4,
      4.857167,
      1,
      0.215406,
      0.000219,
      NULL,
      1,
      NULL,
      1,
      1.063252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0.597015,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.443703,
      0.379985,
      0,
      1,
      1.205537,
      NULL,
      4.545418,
      0.639264,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.899966,
      3.519245,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.928697,
      0.192752,
      2,
      0,
      0.667678,
      2.748151,
      0.440589,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      1.048296,
      1,
      1.132257,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '03412',
      '',
      NULL,
      0.395632,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      2.160959,
      NULL,
      0,
      0.935203,
      NULL,
      0,
      1,
      3.047387,
      0);
commit;
end;
/


