set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '323',
      '24212213',
      84.887024,
      2,
      '1033043',
      32.138578,
      6,
      1.251998,
      NULL,
      '040044',
      3.868980,
      '10- 3-2000',
      127,
      NULL,
      1.929883,
      NULL,
      1,
      1,
      3.577236,
      0.293991,
      0.746919,
      2.251839,
      NULL,
      2.577617,
      1.340511,
      0.497788,
      0.964129,
      1,
      0.459006,
      1.982515,
      1.356147,
      NULL,
      3,
      NULL,
      1.765547,
      0.333424,
      0.212029,
      NULL,
      2.886942,
      NULL,
      4.321184,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      2,
      NULL,
      2,
      NULL,
      0.338858,
      2,
      1,
      2,
      3.213190,
      2.607513,
      NULL,
      0.342163,
      NULL,
      0.388274,
      1.231084,
      NULL,
      NULL,
      2.836820,
      0.885507,
      0.663856,
      0.557739,
      8.794154,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      0.708054,
      NULL,
      NULL,
      1,
      2.149493,
      0.418041,
      0.866579,
      2.128504,
      1,
      NULL,
      0.887157,
      NULL,
      0,
      NULL,
      0.240594,
      1.878310,
      0,
      1,
      NULL,
      1.445794,
      0.841646,
      NULL,
      NULL,
      0,
      9,
      2.990530,
      5,
      2,
      1,
      6,
      1,
      NULL,
      NULL,
      2,
      5,
      4.331393,
      NULL,
      NULL,
      1.380166,
      0.883569,
      2.026137,
      7,
      NULL,
      2,
      4.730518,
      NULL,
      1,
      7.361232,
      5.962265,
      NULL,
      1,
      0,
      1,
      1.263034,
      5,
      0.262419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805102,
      1.442584,
      1,
      NULL,
      0.798124,
      1.450928,
      0.302766,
      0.412549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.112814,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748095,
      2.848224,
      3.842390,
      1.164558,
      1.988904,
      NULL,
      4,
      0.610678,
      0.684364,
      NULL,
      NULL,
      NULL,
      0.806937,
      NULL,
      6.123819,
      5.741941,
      0,
      2,
      1.579221,
      NULL,
      NULL,
      NULL,
      1,
      0.301992,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      NULL,
      1.972051,
      NULL,
      3.399175,
      3.288565,
      1,
      3.172108,
      NULL,
      NULL,
      1.690220,
      1.753200,
      NULL,
      1,
      NULL,
      0.861149,
      0.892488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.519350,
      '40242',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3.163657,
      '43121',
      '',
      '',
      NULL,
      0.876745,
      3.028417,
      1.449469,
      NULL,
      1.504787,
      NULL,
      0,
      NULL);
commit;
end;
/


