set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03211234',
      33.482619,
      14.958151,
      '3122042',
      77.990589,
      NULL,
      2,
      1,
      '314424',
      3.425791,
      '11-20-1985',
      50.133727,
      238,
      0.034542,
      NULL,
      3.314207,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.595495,
      0.682748,
      NULL,
      2.659840,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1.540789,
      3.614401,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.665227,
      NULL,
      NULL,
      7.645214,
      NULL,
      3,
      NULL,
      0,
      1,
      0,
      1.704395,
      3,
      3,
      2.390520,
      0.474449,
      NULL,
      1,
      3,
      2,
      NULL,
      NULL,
      0,
      1.670216,
      1.576916,
      1,
      10,
      1,
      1,
      1,
      1.780107,
      NULL,
      NULL,
      1.894768,
      NULL,
      NULL,
      1.594644,
      5,
      NULL,
      1,
      4,
      0,
      1.679835,
      NULL,
      0,
      0.660317,
      0,
      0.562287,
      1.364081,
      0,
      0.285156,
      NULL,
      0,
      1.194434,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      5,
      2.432336,
      1.646165,
      2.310070,
      6.090847,
      6.210916,
      2,
      2.800834,
      2.875772,
      6,
      6.590070,
      2.093204,
      5.371003,
      2.538701,
      8.058061,
      4,
      4,
      3,
      3,
      1,
      0.553261,
      0.607996,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291378,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792572,
      NULL,
      NULL,
      NULL,
      NULL,
      2.465711,
      0.312312,
      1.013223,
      1,
      NULL,
      2.780763,
      2.041585,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710611,
      NULL,
      6.843944,
      0,
      NULL,
      1.591374,
      NULL,
      NULL,
      NULL,
      NULL,
      3.865898,
      1.806214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962333,
      NULL,
      2.900033,
      2,
      1.320581,
      1,
      1.331625,
      3,
      0.977820,
      1.746600,
      3,
      1.832883,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.518663,
      '02330',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.059837,
      '22431',
      '',
      NULL,
      NULL,
      NULL,
      0,
      1.083867,
      0.579128,
      0.126329,
      2.153299,
      NULL,
      2);
commit;
end;
/


