set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2341',
      '34313124',
      10.768240,
      55,
      '2002113',
      NULL,
      2,
      0.487417,
      1,
      '230011',
      2.474561,
      ' 7-20-2002',
      176.229258,
      90.102453,
      NULL,
      NULL,
      4.451543,
      0,
      0.223264,
      0.700115,
      0.077600,
      0,
      1.953810,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.138114,
      1,
      0.550854,
      0,
      0.404879,
      1.193352,
      1,
      1,
      0.706499,
      0.922118,
      5.101747,
      0,
      4.799511,
      0.597091,
      1.643586,
      NULL,
      NULL,
      NULL,
      0.793957,
      NULL,
      NULL,
      10,
      8,
      8,
      3,
      1,
      1.041058,
      2,
      0.065513,
      NULL,
      0,
      3.589799,
      1,
      0.224110,
      1.320264,
      2,
      3,
      0.995312,
      3,
      3,
      0,
      1,
      0,
      0,
      0,
      1,
      0.181741,
      0,
      NULL,
      NULL,
      1.931778,
      NULL,
      NULL,
      1,
      4,
      1.733435,
      0,
      0,
      0.971509,
      NULL,
      0.835643,
      NULL,
      NULL,
      1.651120,
      0,
      0,
      0.778728,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0.406829,
      NULL,
      4,
      1,
      8,
      0.436059,
      5.566027,
      3.149927,
      2.611236,
      0,
      1,
      3,
      2,
      2.314768,
      1.918530,
      3,
      7.801070,
      4.310479,
      4,
      2,
      3.025672,
      0,
      3,
      0,
      1.804848,
      1.029542,
      NULL,
      0,
      1,
      4,
      0.609711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569672,
      1.657902,
      NULL,
      1,
      0,
      1,
      0.277125,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.565183,
      1,
      1,
      0.311503,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      6.443913,
      1.986658,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816012,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.889538,
      1,
      2.475529,
      NULL,
      1.794480,
      3,
      0,
      0.684060,
      3.511168,
      0,
      1.459193,
      0.706309,
      1,
      1.612410,
      0.658918,
      0.801341,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '31043',
      NULL,
      NULL,
      1.789664,
      '',
      '',
      '',
      3,
      '40112',
      '',
      NULL,
      5.349483,
      2,
      1,
      1,
      1.513834,
      2,
      3,
      NULL,
      3);
commit;
end;
/


