set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2300',
      '22413342',
      78,
      78,
      '4023232',
      108.752349,
      NULL,
      1.369268,
      0,
      '403032',
      5,
      NULL,
      89.873630,
      NULL,
      NULL,
      NULL,
      3.351541,
      NULL,
      NULL,
      1,
      0,
      1.631254,
      NULL,
      1,
      0,
      0,
      3.206353,
      NULL,
      1.330130,
      NULL,
      0.679041,
      NULL,
      1,
      1.250012,
      NULL,
      0.789807,
      0,
      0,
      6.156752,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.436521,
      NULL,
      4.561410,
      2.711024,
      0,
      1,
      1,
      NULL,
      3,
      NULL,
      1.808312,
      0.554742,
      3,
      1,
      0,
      0,
      3.418386,
      0.305870,
      1,
      NULL,
      0,
      NULL,
      11,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128257,
      NULL,
      1.559577,
      NULL,
      3,
      0.609088,
      0,
      0.396514,
      0,
      NULL,
      1,
      NULL,
      1.251983,
      NULL,
      0,
      0.995346,
      1.369900,
      1,
      0,
      NULL,
      0,
      9.971859,
      0.411914,
      NULL,
      NULL,
      NULL,
      4,
      0,
      6,
      0,
      NULL,
      NULL,
      2.014070,
      9,
      7,
      2,
      2.664547,
      3.926125,
      8,
      4,
      7.643092,
      NULL,
      2.552048,
      1,
      4.025817,
      0.599624,
      7.329981,
      NULL,
      0,
      1,
      0.173826,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602120,
      1.266248,
      1,
      1,
      0.719603,
      1.675976,
      0.554885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407877,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.979139,
      1.124171,
      6.932855,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.767960,
      3.817953,
      2.896050,
      0.513624,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.460288,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.246406,
      2.177411,
      2.756444,
      NULL,
      0,
      2,
      NULL,
      0.250766,
      NULL,
      1,
      NULL,
      0.288371,
      1,
      1.645381,
      0,
      1,
      1.582507,
      1,
      1.362185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.200641,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      NULL,
      4,
      3,
      2,
      0,
      0.484244,
      3,
      NULL,
      0,
      0.970698);
commit;
end;
/


