set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2201',
      NULL,
      62.574747,
      28,
      '2321030',
      88,
      2,
      1.454584,
      0,
      '104412',
      3.746767,
      ' 4-16-1974',
      133,
      24.491814,
      NULL,
      NULL,
      1.263127,
      0.828226,
      0.147890,
      1.155013,
      0.959197,
      1,
      1.323562,
      2,
      1,
      1,
      5.017465,
      NULL,
      1.772907,
      0.703116,
      1,
      0,
      2.125069,
      NULL,
      0,
      0.578220,
      NULL,
      0,
      NULL,
      1,
      3.147755,
      1.709271,
      NULL,
      0,
      NULL,
      NULL,
      0.133595,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1.306126,
      NULL,
      3.506364,
      1.292263,
      1.975287,
      1,
      0,
      2,
      1.427290,
      NULL,
      1,
      0.441354,
      3,
      1,
      0.728258,
      1,
      1,
      0.108628,
      NULL,
      1,
      0,
      0,
      1.205475,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.091252,
      0,
      NULL,
      0,
      4.216901,
      0,
      1,
      1.665202,
      0.741418,
      0,
      1,
      0,
      1.810308,
      1,
      0.643842,
      1,
      0.693733,
      0.965310,
      1.152023,
      NULL,
      0,
      9,
      1,
      1,
      5,
      1,
      5.111474,
      1,
      1,
      4.749941,
      5.172010,
      1.084333,
      1.648984,
      0,
      NULL,
      0.951673,
      NULL,
      0.063937,
      5.677672,
      NULL,
      NULL,
      5,
      6.836965,
      6.880581,
      0.169352,
      4,
      2,
      3,
      0.401610,
      1,
      0.358818,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.251939,
      0,
      1,
      1,
      0.045520,
      1.213438,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.120284,
      1,
      NULL,
      0,
      2.941719,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.097297,
      7.628743,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.018725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155247,
      0.243778,
      2.024902,
      2,
      1,
      1,
      1,
      3,
      0,
      3,
      0.274411,
      0,
      0.737990,
      0.529692,
      1.976309,
      1.853206,
      1,
      0,
      0.918506,
      1.786164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.123559,
      '30221',
      '',
      '',
      0,
      '',
      '',
      '',
      1.849827,
      NULL,
      '',
      '',
      1,
      NULL,
      3,
      2,
      3.400572,
      1,
      2,
      0.364659,
      0.816852);
commit;
end;
/


