set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8535651';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      NULL,
      23,
      22,
      '1223243',
      NULL,
      4,
      NULL,
      1,
      '103044',
      0,
      ' 8- 4-1990',
      NULL,
      5.064033,
      1,
      NULL,
      1,
      1.831165,
      0.473402,
      0.691827,
      0,
      0.323905,
      1.440557,
      1.690171,
      1,
      0,
      0.791065,
      2.008133,
      NULL,
      1.176834,
      0.573676,
      1,
      1.530263,
      1,
      1,
      0.777311,
      0.007665,
      1,
      4,
      0,
      3,
      3.470614,
      1,
      0,
      NULL,
      NULL,
      0.243056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.086005,
      1,
      0.505080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.110675,
      NULL,
      NULL,
      7,
      NULL,
      5,
      2,
      1,
      4.384951,
      NULL,
      2,
      1.377131,
      0.572394,
      NULL,
      NULL,
      1.067261,
      NULL,
      1,
      1.104857,
      0.617678,
      0,
      NULL,
      0.919751,
      1,
      1.403447,
      0,
      1,
      0,
      1.468784,
      1.595612,
      0.221149,
      0.856728,
      1,
      NULL,
      3,
      0.042273,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      7.325569,
      NULL,
      NULL,
      1.976961,
      1.376645,
      0.043995,
      0.249665,
      0.958119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413066,
      0,
      1,
      NULL,
      0.188542,
      5.372938,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.513779,
      1.997367,
      1,
      NULL,
      NULL,
      NULL,
      7.420684,
      1.981856,
      0,
      0,
      1.455293,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.383335,
      3.023687,
      1.794133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191383,
      NULL,
      1.863116,
      NULL,
      0.000084,
      1.670143,
      1.690615,
      0.068447,
      0,
      3.010137,
      0,
      1,
      1,
      NULL,
      1,
      1.569095,
      NULL,
      0,
      NULL,
      0.595901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '21244',
      '03232',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


