set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8706881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3443',
      '14012223',
      82,
      NULL,
      '0132341',
      9.085092,
      NULL,
      NULL,
      3,
      '231424',
      5,
      ' 0-25-1995',
      12.747107,
      55,
      0,
      NULL,
      0,
      NULL,
      0.375690,
      1,
      NULL,
      1.385076,
      1.307881,
      NULL,
      1.110747,
      1.471195,
      7,
      1.849001,
      0.635692,
      4.740694,
      2,
      1,
      5,
      1,
      1,
      1,
      1.796842,
      NULL,
      NULL,
      1,
      1.102715,
      0,
      3.921326,
      0.573625,
      NULL,
      NULL,
      0.336330,
      NULL,
      NULL,
      1,
      2,
      3.029442,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.635065,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      3.013485,
      0.831899,
      1,
      5,
      NULL,
      1.091517,
      0.649037,
      4.513589,
      0.191823,
      NULL,
      1.298209,
      0.363315,
      1,
      0,
      1.485958,
      1.459410,
      1.417489,
      NULL,
      NULL,
      4.851744,
      NULL,
      0,
      4,
      0.705673,
      NULL,
      0,
      5,
      0,
      1.261982,
      3.852307,
      0,
      1,
      4.499608,
      6,
      1,
      7,
      1.350672,
      3,
      0.973699,
      3.029161,
      5.402439,
      0,
      4,
      3,
      NULL,
      0,
      0.272632,
      0,
      0.415273,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.394355,
      1.880497,
      0.520605,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9,
      0.522248,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581955,
      1,
      0.115501,
      NULL,
      NULL,
      NULL,
      2,
      1.909257,
      4.180326,
      0.604176,
      3.613985,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.192114,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.113256,
      1.171628,
      0,
      3,
      NULL,
      0,
      1,
      1,
      0.633843,
      0.311315,
      0.049772,
      1.646894,
      1,
      1.048947,
      1.647125,
      0.992533,
      NULL,
      1.659011,
      0.477223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24113',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      3.666361,
      '20124',
      '',
      '',
      6.279591,
      2,
      0,
      NULL,
      NULL,
      0.692054,
      3,
      0,
      NULL);
commit;
end;
/


