set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8706881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4220',
      '20222100',
      33,
      NULL,
      '4332242',
      2,
      NULL,
      3.222217,
      NULL,
      '321343',
      NULL,
      ' 6-28-1991',
      3.275724,
      37.301006,
      NULL,
      NULL,
      NULL,
      0.854166,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.216377,
      1.275920,
      0,
      7,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.172008,
      1,
      1,
      1,
      5.399535,
      0,
      3.681793,
      0.939401,
      1,
      0,
      NULL,
      NULL,
      0.580214,
      NULL,
      NULL,
      3.564452,
      1.997149,
      0.950445,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869988,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463839,
      4.125192,
      1,
      0.949676,
      0,
      0.359357,
      0,
      NULL,
      1,
      4,
      4,
      NULL,
      0.976973,
      1,
      0,
      1.567998,
      NULL,
      1,
      1.496365,
      NULL,
      1,
      0.929222,
      1.922718,
      0,
      1.110514,
      1,
      NULL,
      0.924392,
      0,
      1,
      NULL,
      1.950513,
      0,
      1,
      0.435148,
      NULL,
      0.971840,
      NULL,
      2.592905,
      NULL,
      NULL,
      5,
      3,
      1.545769,
      7,
      1,
      NULL,
      3.034509,
      2,
      1.494491,
      NULL,
      6.667863,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.609573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.973816,
      NULL,
      3.791429,
      NULL,
      2,
      1.980774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.912533,
      0.438810,
      1.070548,
      NULL,
      NULL,
      1,
      0.540071,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918660,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.535730,
      1,
      NULL,
      NULL,
      1.236860,
      2.790098,
      1.654756,
      3.155306,
      0,
      0.685225,
      0.850547,
      0.707119,
      1,
      1.496778,
      1.728863,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '41144',
      '43200',
      '',
      0.807623,
      '',
      '',
      '',
      1.232590,
      '20241',
      '',
      '',
      4,
      NULL,
      2.698656,
      4,
      0,
      5,
      1,
      2,
      1);
commit;
end;
/


