set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8706881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20444031',
      80.801311,
      40,
      '0311101',
      37,
      4,
      3,
      1,
      '141341',
      4.848161,
      NULL,
      7.530072,
      36,
      1.961646,
      NULL,
      1.430646,
      NULL,
      1,
      1.155374,
      1,
      NULL,
      1.404556,
      1,
      1.948295,
      0,
      3.528079,
      0,
      1.387485,
      0.785519,
      1,
      1.675393,
      2.621402,
      NULL,
      NULL,
      2,
      2.747620,
      NULL,
      4,
      NULL,
      5.838479,
      3.087461,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1.421456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817545,
      1.759002,
      1,
      3.751797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119911,
      0,
      5,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.865409,
      1,
      NULL,
      0,
      0,
      0,
      1.951329,
      1,
      0.786794,
      NULL,
      0,
      NULL,
      0.498214,
      1,
      0.981061,
      0,
      0,
      1,
      1,
      0,
      5.156548,
      1.438039,
      0.965680,
      NULL,
      1,
      1.115780,
      NULL,
      NULL,
      1,
      3.963319,
      0.397263,
      1,
      2.155430,
      0.580637,
      NULL,
      0,
      4.818169,
      1,
      NULL,
      3,
      NULL,
      0.191277,
      0,
      2.517082,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810222,
      1.107026,
      NULL,
      1,
      0.382661,
      0.594443,
      1,
      1.012022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5,
      3,
      3.956522,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.507225,
      1,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.132754,
      0.750337,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      2,
      0.909938,
      NULL,
      1,
      3,
      0.469714,
      0.861824,
      NULL,
      NULL,
      1,
      0.567695,
      1.603474,
      1.307292,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '31112',
      '24330',
      '',
      1.888812,
      NULL,
      '',
      NULL,
      1.397428,
      '14304',
      '',
      '',
      1.693996,
      NULL,
      0.642596,
      1.189421,
      1,
      1,
      2.609200,
      1.146844,
      0.636255);
commit;
end;
/


