set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      '20',
      20.882355,
      5.503082,
      '3021131',
      3,
      4,
      NULL,
      2,
      '112432',
      4.588657,
      '11-10-1996',
      49.701941,
      6,
      0.979517,
      NULL,
      0.968300,
      0.241660,
      NULL,
      1.399749,
      0,
      1,
      3.828064,
      0,
      0,
      1.709523,
      NULL,
      1.847706,
      NULL,
      NULL,
      1.723868,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.322557,
      0.747231,
      3,
      NULL,
      NULL,
      0.377895,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.203086,
      0.283143,
      1.791697,
      3,
      1,
      NULL,
      3.089529,
      0,
      1,
      NULL,
      3,
      NULL,
      0.681501,
      0.326023,
      3,
      1.273470,
      NULL,
      0.587240,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1.583618,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.288804,
      1,
      1.507101,
      1,
      NULL,
      1,
      1.537640,
      1.964122,
      1,
      NULL,
      0,
      1,
      1.765891,
      NULL,
      0.975173,
      0.074259,
      NULL,
      1,
      2.750231,
      3,
      5.666155,
      1.844940,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      2.897020,
      2.097420,
      5,
      5.031595,
      0,
      1,
      7.961340,
      3.691506,
      0,
      0.234970,
      8,
      7.243114,
      7.743951,
      0,
      NULL,
      NULL,
      8.058369,
      7.576514,
      4,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.518524,
      1.853049,
      0.827604,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8.674053,
      NULL,
      1,
      1.786262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834881,
      NULL,
      NULL,
      NULL,
      2,
      0.346925,
      5,
      5,
      0.074775,
      1,
      3.537462,
      NULL,
      NULL,
      NULL,
      1.266808,
      7.961409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587280,
      NULL,
      2,
      NULL,
      NULL,
      0.445198,
      NULL,
      NULL,
      0.114156,
      NULL,
      NULL,
      1.222980,
      0.359786,
      1.889762,
      NULL,
      0.144540,
      NULL,
      NULL,
      0.100819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      '12211',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      4.569469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


