set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '420',
      '23',
      14.931626,
      9.032010,
      NULL,
      18.213416,
      NULL,
      3.053891,
      2,
      '311403',
      2.877850,
      ' 9- 4-1982',
      NULL,
      57.237054,
      1,
      NULL,
      NULL,
      0.015940,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.508493,
      4.550611,
      0,
      1.345962,
      NULL,
      NULL,
      0,
      6,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      3.328010,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      1,
      1.409072,
      1,
      0,
      3,
      0.693358,
      1.350646,
      1.967492,
      0.456252,
      0.953986,
      2,
      0.600566,
      3,
      1.781058,
      0.396403,
      1,
      1,
      0,
      1.197788,
      1.312549,
      1.189635,
      0,
      1,
      0.366712,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.030264,
      1.721327,
      0,
      1,
      0.495792,
      1.798706,
      0.415008,
      1,
      1,
      1,
      1.409309,
      3,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      1.501711,
      1.726941,
      NULL,
      1.833701,
      0.399519,
      0,
      0,
      0.945326,
      3,
      NULL,
      NULL,
      NULL,
      5.883328,
      NULL,
      3,
      2,
      6.826082,
      0.697865,
      1.355686,
      0.653413,
      NULL,
      0,
      7.879791,
      NULL,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.967281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158251,
      1.973641,
      1,
      1,
      0.031137,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.272470,
      1,
      NULL,
      5.653337,
      1.998169,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0.439368,
      NULL,
      0.610169,
      NULL,
      2,
      1.618227,
      NULL,
      NULL,
      NULL,
      1,
      10.306118,
      1.489115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.234193,
      0,
      1,
      1,
      2.698548,
      0.523752,
      0,
      0.275661,
      3.148162,
      2.820224,
      1,
      0,
      1,
      0.157079,
      0.039394,
      NULL,
      1,
      1,
      0.044016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '44013',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


