set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41141431',
      24.457449,
      45,
      '3220232',
      9.475888,
      0,
      3,
      2,
      '040233',
      0,
      '10- 1-1989',
      NULL,
      60.238823,
      0,
      NULL,
      0.189947,
      0.646987,
      0,
      0,
      1.394167,
      1,
      NULL,
      0.312582,
      2,
      1,
      0.924645,
      1,
      0.139176,
      0.194546,
      1,
      1.720118,
      3.825213,
      NULL,
      0.821016,
      0,
      0,
      NULL,
      1.409284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      1,
      1.243525,
      0.367679,
      0.841553,
      3,
      0,
      0.481515,
      3,
      NULL,
      1.285864,
      0.261681,
      NULL,
      1,
      0.561030,
      1,
      0.801451,
      1.082496,
      NULL,
      0,
      0,
      3.444434,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.086552,
      NULL,
      NULL,
      0,
      0.816784,
      1.448038,
      1,
      0,
      1,
      1.112746,
      NULL,
      0.157808,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.371244,
      1.342504,
      1,
      NULL,
      0,
      2,
      0.713994,
      5,
      1.292104,
      1.986731,
      0.938487,
      1.728842,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.381689,
      0,
      5.268908,
      0,
      1.602134,
      1,
      1,
      0.746485,
      0.846320,
      1.890130,
      0,
      0,
      2.894960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1.152850,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.939653,
      NULL,
      6,
      3,
      1,
      1.236577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0,
      1.263758,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      7.737049,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.613677,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.276688,
      0.101929,
      3.429054,
      NULL,
      2,
      2,
      0.947497,
      1,
      0.890337,
      1.056876,
      0,
      0,
      1,
      0.024505,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '20231',
      '32141',
      '',
      0.843818,
      NULL,
      '',
      '',
      1.931681,
      NULL,
      NULL,
      '',
      2.243091,
      1.325526,
      1,
      4,
      NULL,
      3.043899,
      NULL,
      NULL,
      4);
commit;
end;
/


