set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '300',
      '34123434',
      69,
      54.876158,
      '0011210',
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      ' 6-21-1983',
      NULL,
      0.675920,
      0.501396,
      NULL,
      NULL,
      1.822573,
      1,
      0.107949,
      0.056978,
      0,
      NULL,
      1,
      0.475963,
      1.648290,
      NULL,
      NULL,
      1,
      NULL,
      1.689766,
      0.173155,
      4,
      1.363218,
      0,
      NULL,
      3.066799,
      1,
      0.324978,
      0,
      2.702960,
      0.393163,
      2.869719,
      0,
      NULL,
      NULL,
      0.133084,
      NULL,
      NULL,
      NULL,
      1,
      1.305229,
      NULL,
      1.644117,
      NULL,
      1.332002,
      1.959175,
      1,
      0,
      2,
      1.556916,
      1.170076,
      2.850307,
      1,
      0,
      2.076207,
      0,
      NULL,
      NULL,
      0.790411,
      NULL,
      NULL,
      1,
      2,
      0,
      0.438399,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.559099,
      0,
      1.066207,
      0,
      0.790330,
      0,
      0.520059,
      0,
      0.010659,
      NULL,
      0.721314,
      NULL,
      1,
      NULL,
      1.368389,
      1.868314,
      0.255180,
      1.303433,
      1.527198,
      NULL,
      1,
      1.331063,
      1,
      NULL,
      1,
      1.980721,
      NULL,
      1.305668,
      4,
      0.926518,
      0,
      NULL,
      NULL,
      0.310723,
      NULL,
      1.003152,
      2.113007,
      NULL,
      0.033677,
      0.828542,
      2,
      1.872693,
      1,
      NULL,
      4.356102,
      0.869686,
      1.306524,
      NULL,
      2.840540,
      1,
      0.866347,
      3.826674,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312035,
      0,
      1,
      1,
      1.222196,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.286246,
      NULL,
      5.293784,
      NULL,
      0.802259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.486205,
      1.771057,
      1.176465,
      NULL,
      0,
      NULL,
      0.686279,
      NULL,
      NULL,
      NULL,
      0.821030,
      1.370477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.036691,
      1.519047,
      1.205146,
      NULL,
      1,
      2,
      0.484039,
      1.053689,
      2.780077,
      1,
      1.063936,
      1,
      1.970790,
      0.054316,
      1.626075,
      0.823809,
      1.468579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.829483,
      NULL,
      '10301',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      2.269588,
      NULL,
      0,
      0,
      1);
commit;
end;
/


