set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      '04332232',
      77.375881,
      74,
      NULL,
      149,
      3,
      0,
      1,
      '412031',
      1,
      '10- 3-1993',
      54.165505,
      35,
      0.463094,
      NULL,
      1.679386,
      1,
      1,
      0.528034,
      1.530409,
      1.847095,
      0.756162,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1.343047,
      4,
      1.142302,
      1.388950,
      2,
      0,
      0,
      3.731525,
      0.294054,
      0.309391,
      1,
      4.153327,
      1,
      0.954896,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.526622,
      0,
      1,
      1,
      1.549400,
      1.623437,
      1.578929,
      1.004307,
      3,
      2,
      0,
      3,
      0.495818,
      0,
      0.626620,
      1,
      NULL,
      0.871461,
      0,
      0,
      1,
      2.393963,
      1,
      1,
      1.618847,
      0,
      NULL,
      NULL,
      1.300756,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.634531,
      1,
      1.052387,
      1.529552,
      1,
      0.810642,
      0,
      0.319070,
      1,
      1.664134,
      0,
      1.296795,
      1,
      0.866782,
      0.299345,
      NULL,
      NULL,
      0.896454,
      1.535959,
      NULL,
      0.519508,
      0.694524,
      NULL,
      1,
      3.676670,
      NULL,
      1.679224,
      NULL,
      0,
      1.328834,
      2.829362,
      0,
      5.003327,
      1.196384,
      4,
      0,
      6.714625,
      NULL,
      0.899701,
      NULL,
      2.698837,
      NULL,
      0.277071,
      1.439165,
      3,
      1.288475,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837569,
      0,
      0,
      0,
      NULL,
      1,
      0.156228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823550,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.658076,
      4,
      1,
      1.577287,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.813836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547764,
      0,
      3.517588,
      NULL,
      0,
      1.802984,
      0,
      0.299868,
      NULL,
      1,
      0.539490,
      1.483615,
      NULL,
      NULL,
      0.106509,
      NULL,
      0,
      NULL,
      1.921617,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '34342',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      5,
      3,
      3,
      1,
      2,
      1.557096,
      NULL,
      1.245799,
      0.171121);
commit;
end;
/


