set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '44431020',
      5.503662,
      59.451274,
      '4403110',
      7,
      0,
      2,
      2,
      '224323',
      2.763481,
      ' 0-24-1977',
      NULL,
      NULL,
      0,
      NULL,
      1.284628,
      3.506364,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1.880209,
      NULL,
      1,
      1.231173,
      NULL,
      6.575699,
      0.327455,
      NULL,
      NULL,
      0,
      NULL,
      0.649155,
      0.753140,
      NULL,
      1,
      5.663019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999431,
      3.894307,
      0,
      NULL,
      NULL,
      1.199832,
      0.079046,
      2,
      1.980216,
      0.240618,
      0,
      1,
      1,
      1.890882,
      1.768895,
      0.623097,
      1,
      1,
      1.600016,
      NULL,
      0.570784,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.522282,
      NULL,
      NULL,
      NULL,
      0.580370,
      0,
      1,
      1.514067,
      0,
      1.018565,
      1,
      1.624601,
      1,
      1.621575,
      NULL,
      0,
      0,
      1,
      1.178346,
      1,
      1.252027,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1.147384,
      1.080672,
      0.785799,
      NULL,
      1.165681,
      1.459882,
      1,
      0.465931,
      NULL,
      0.155731,
      0,
      0,
      0.573134,
      0,
      2,
      NULL,
      5.487298,
      7,
      5.739133,
      NULL,
      5.310329,
      0,
      1,
      NULL,
      2.978665,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256819,
      0.443560,
      1,
      1,
      1,
      0,
      0.666456,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.880968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395950,
      NULL,
      4,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.291809,
      NULL,
      0.040926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068854,
      1,
      NULL,
      0.811960,
      1,
      NULL,
      NULL,
      3.366441,
      0.403284,
      2,
      0,
      1.487914,
      0.559048,
      0,
      NULL,
      1,
      NULL,
      0,
      1.688530,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '44434',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      3,
      3.889971,
      3,
      2,
      2.916318,
      7,
      0.355856,
      3.187244,
      1.006734);
commit;
end;
/


