set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      '43440334',
      NULL,
      73,
      '2114013',
      111.129937,
      4,
      3,
      0,
      '421222',
      4.741267,
      ' 6-28-1998',
      NULL,
      18.994519,
      1,
      NULL,
      NULL,
      1.140649,
      NULL,
      0,
      0.381563,
      3,
      3.017332,
      1.023182,
      0.091812,
      1,
      2.128107,
      0.292639,
      0.917061,
      0,
      5,
      0.525862,
      2.591566,
      0.294851,
      1.431600,
      0,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.800690,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.331021,
      0,
      2.819298,
      NULL,
      2.182777,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.191412,
      1,
      3.860426,
      1.277430,
      0.357638,
      0,
      1.766108,
      0,
      NULL,
      0.156623,
      3,
      NULL,
      0,
      0,
      1.394078,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.318228,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.868817,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0.918646,
      1.285872,
      1,
      NULL,
      NULL,
      NULL,
      1.720953,
      NULL,
      NULL,
      1.125523,
      0.811193,
      NULL,
      1.039991,
      NULL,
      0.455448,
      NULL,
      NULL,
      NULL,
      1.322836,
      NULL,
      1.032122,
      NULL,
      3.658172,
      5.934104,
      0.623619,
      3,
      0.362483,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      8,
      0.888241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378909,
      1,
      1,
      1,
      0,
      1,
      0.238130,
      1.771531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079759,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.594278,
      1.842296,
      4,
      0,
      1,
      0.008070,
      NULL,
      NULL,
      NULL,
      1,
      1.248037,
      1.518777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540675,
      NULL,
      1.808903,
      1.597191,
      3,
      0.325798,
      NULL,
      1.232388,
      NULL,
      3.249213,
      0,
      1,
      NULL,
      0,
      1.275862,
      NULL,
      1.891674,
      1,
      0,
      1.831446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.394021,
      '04444',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.508665,
      '',
      NULL,
      '',
      5,
      3,
      1,
      5.838774,
      3,
      2,
      3,
      NULL,
      1);
commit;
end;
/


