set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4133',
      '44320140',
      48.908825,
      48.304061,
      '0204002',
      20,
      0,
      0.464617,
      1,
      '030103',
      4.979361,
      NULL,
      18.978361,
      34,
      1,
      NULL,
      1.348931,
      0,
      0.308118,
      NULL,
      0,
      0.783530,
      NULL,
      1,
      3.919142,
      1.386570,
      7.814726,
      1.535883,
      1.614894,
      0.453083,
      4,
      NULL,
      5.957220,
      0,
      1,
      0.147073,
      3,
      NULL,
      6,
      1,
      4.601818,
      1,
      3.359993,
      0,
      NULL,
      NULL,
      0.613328,
      NULL,
      NULL,
      1,
      NULL,
      1.277745,
      2.815797,
      0,
      2.357252,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.922697,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.658417,
      1,
      1.224597,
      9,
      1,
      1,
      0.667870,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.857290,
      2,
      0.574910,
      3,
      1,
      1.825782,
      0,
      1.760854,
      0.151459,
      0,
      NULL,
      0.353825,
      1,
      1.994476,
      NULL,
      0,
      1,
      1.246170,
      NULL,
      0,
      1,
      1.212525,
      NULL,
      NULL,
      1.165650,
      0.814651,
      1.491060,
      1.999732,
      1.947367,
      NULL,
      3.187353,
      1.771246,
      1.492008,
      1,
      0.003985,
      0,
      4.386467,
      NULL,
      NULL,
      3,
      0.805804,
      5,
      2.465290,
      0,
      2,
      0,
      0.330776,
      2,
      1.880316,
      0.165662,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.557266,
      1.707446,
      1.781392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.886316,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318513,
      0,
      0,
      0,
      NULL,
      0.622712,
      NULL,
      0,
      3,
      0,
      1.924824,
      NULL,
      1.394706,
      0,
      2.079129,
      7.593453,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.855706,
      0.152945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035654,
      3.954434,
      NULL,
      NULL,
      1,
      0.177912,
      1,
      0.523176,
      0,
      3.780822,
      NULL,
      1.432642,
      1.424755,
      0,
      0,
      1.155298,
      NULL,
      0.736784,
      0.334764,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.587177,
      '40322',
      '',
      '',
      0.721111,
      '',
      '',
      '',
      2,
      '4211',
      '',
      '',
      0.232632,
      2.229105,
      3,
      4,
      1,
      1.547495,
      0.529578,
      3.681478,
      1.753012);
commit;
end;
/


