set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4320',
      '13144323',
      NULL,
      10.689754,
      NULL,
      86.193572,
      NULL,
      3,
      2,
      '322413',
      1.510300,
      NULL,
      44.006771,
      52,
      1,
      NULL,
      0.851745,
      2.230924,
      1.584872,
      0,
      1.932640,
      NULL,
      NULL,
      1,
      1.692830,
      1,
      6,
      1.141751,
      0.087217,
      NULL,
      6.558360,
      0,
      1.238853,
      1.731391,
      0.141883,
      1.662264,
      4.578445,
      1.539879,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.826248,
      1.883271,
      1,
      2,
      0.425495,
      NULL,
      0.608576,
      1,
      1.509051,
      2.108911,
      NULL,
      0,
      2.659121,
      0,
      NULL,
      NULL,
      0,
      1.664317,
      NULL,
      1.929574,
      0.634931,
      0,
      NULL,
      0,
      2,
      1,
      0.834232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361104,
      0.202625,
      0.346030,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0.574404,
      1.989629,
      NULL,
      0.051227,
      0.290185,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.277189,
      0.281236,
      NULL,
      0,
      NULL,
      0.137633,
      1.212366,
      3.200822,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3,
      4,
      NULL,
      4,
      0.618629,
      5,
      NULL,
      7.167385,
      2.862306,
      1.889909,
      3,
      0.097274,
      0,
      0,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731129,
      0,
      NULL,
      1.275553,
      NULL,
      0.999254,
      1.316381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.567428,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.339695,
      4.894484,
      5.386217,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.684681,
      1.364124,
      0.391274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644281,
      1,
      3.365018,
      1,
      1.718885,
      NULL,
      0,
      2.209079,
      0.812357,
      2,
      0,
      1,
      0,
      0.817849,
      NULL,
      NULL,
      0.283138,
      0.626815,
      0,
      0.445426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.767388,
      '41312',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2,
      '4130',
      NULL,
      '',
      2.479376,
      0,
      2,
      0,
      7,
      9,
      NULL,
      2.006307,
      0);
commit;
end;
/


