set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2231',
      '20320024',
      NULL,
      48.535592,
      '0412041',
      111,
      1,
      1,
      3,
      '043210',
      NULL,
      ' 8-28-1994',
      28,
      8,
      1,
      NULL,
      0.870235,
      2,
      1,
      1.806253,
      1,
      0.144742,
      0.571356,
      0,
      0.935583,
      1,
      0,
      NULL,
      1.738043,
      0.629192,
      1,
      0,
      1.685691,
      0.627561,
      0.124414,
      1,
      2.681685,
      0.220344,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.742238,
      0,
      0,
      NULL,
      0.992647,
      0.840913,
      NULL,
      0,
      NULL,
      0,
      0,
      1.566775,
      2.506309,
      0,
      1.409457,
      NULL,
      NULL,
      1.423191,
      1,
      NULL,
      4.942147,
      1,
      1,
      0.546044,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255617,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1.424831,
      0.991193,
      1,
      1.108114,
      0.903423,
      1,
      NULL,
      1.065929,
      1,
      0,
      NULL,
      1.805937,
      1,
      NULL,
      NULL,
      1,
      1.301646,
      0.100380,
      0.153584,
      2.618119,
      0.707305,
      3.919398,
      2,
      1,
      1,
      1.288036,
      1,
      NULL,
      2.346411,
      3,
      NULL,
      5.560056,
      4,
      0,
      5.578394,
      NULL,
      3.993872,
      0.020331,
      2.717462,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.526372,
      NULL,
      1,
      1.026227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.613576,
      0.672217,
      NULL,
      NULL,
      NULL,
      3.060872,
      1.748378,
      NULL,
      3,
      1.244864,
      0,
      4.011653,
      NULL,
      NULL,
      NULL,
      0.924678,
      NULL,
      1.070049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612743,
      1.200824,
      NULL,
      0.259326,
      3.237448,
      0,
      1,
      2.963020,
      1,
      0,
      NULL,
      1.629993,
      0.330320,
      0,
      0,
      NULL,
      0,
      0.446480,
      0.353728,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053701,
      '40013',
      NULL,
      '',
      0.555415,
      '',
      '',
      '',
      0.357836,
      '3343',
      '',
      '',
      2,
      4.871790,
      0.056179,
      3,
      1,
      0,
      1,
      NULL,
      0.890569);
commit;
end;
/


