set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23003444',
      28.924837,
      49,
      '4101402',
      210.607759,
      2,
      0,
      3,
      '022242',
      5,
      ' 8-27-1992',
      2,
      32,
      0,
      NULL,
      0,
      1,
      1.307707,
      1.455138,
      1.673957,
      0,
      3.574082,
      NULL,
      1.958016,
      1,
      1.690701,
      1.214453,
      1,
      0.378094,
      1,
      NULL,
      0,
      NULL,
      0.551945,
      NULL,
      NULL,
      1.640609,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.417240,
      0.100575,
      NULL,
      0.332110,
      1,
      NULL,
      1.207764,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.427717,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.704996,
      NULL,
      0.266786,
      0,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.816354,
      1.682904,
      0.216248,
      1.746189,
      NULL,
      1,
      1.286944,
      1,
      1,
      0,
      0,
      0.276772,
      1,
      1,
      NULL,
      1,
      0.958624,
      NULL,
      NULL,
      0,
      1.465313,
      NULL,
      0,
      0,
      NULL,
      1.601823,
      1.610804,
      1.962444,
      0,
      0,
      0.057368,
      1.757501,
      1.751627,
      1.932307,
      NULL,
      NULL,
      NULL,
      1.423846,
      2,
      5,
      1.639268,
      0,
      NULL,
      3,
      0,
      3,
      0,
      NULL,
      NULL,
      3.782568,
      0.383680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448939,
      NULL,
      NULL,
      NULL,
      1,
      1.428881,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662499,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507789,
      1,
      5.264179,
      NULL,
      1,
      0,
      0.417667,
      NULL,
      NULL,
      NULL,
      1.421835,
      0.688494,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.658578,
      1,
      1,
      1.586831,
      1,
      2.290133,
      0.194908,
      1.644712,
      1.885545,
      0.385616,
      0,
      NULL,
      0.752172,
      1,
      1,
      1.845178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '02411',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1.674556,
      '4021',
      '',
      '',
      4,
      0.416343,
      2,
      0.626109,
      0,
      3,
      2.788357,
      2,
      5.167730);
commit;
end;
/


